/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.james.backends.cassandra.utils.ZonedDateTimeRepresentation;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ZonedDateTimeRepresentationTest {
    private static final ZonedDateTime ZONED_DATE_TIME_VN = ZonedDateTime.parse("2016-04-13T12:04:40.906+07:00[Asia/Vientiane]");
    private static final ZonedDateTime ZONED_DATE_TIME_FR = ZonedDateTime.parse("2016-04-13T07:04:40.906+02:00");
    private static final long INSTANT = 1460523880906L;

    @Test
    public void zonedDateTimeRepresentationShouldBeReversible() {
        ZonedDateTimeRepresentation originalValue = ZonedDateTimeRepresentation.fromZonedDateTime((ZonedDateTime)ZONED_DATE_TIME_VN);
        ZonedDateTimeRepresentation generatedValue = ZonedDateTimeRepresentation.fromDate((Date)originalValue.getDate(), (String)originalValue.getSerializedZoneId());
        Assertions.assertThat((ZonedDateTime)originalValue.getZonedDateTime()).isEqualTo(generatedValue.getZonedDateTime());
    }

    @Test
    public void getSerializedZoneIdShouldReturnTheRightZone() {
        Assertions.assertThat((String)ZonedDateTimeRepresentation.fromZonedDateTime((ZonedDateTime)ZONED_DATE_TIME_VN).getSerializedZoneId()).isEqualTo((Object)"Asia/Vientiane");
    }

    @Test
    public void getDateShouldReturnTheRightDate() {
        Assertions.assertThat((long)ZonedDateTimeRepresentation.fromZonedDateTime((ZonedDateTime)ZONED_DATE_TIME_VN).getDate().getTime()).isEqualTo(1460523880906L);
    }

    @Test
    public void getSerializedZoneIdShouldWorkWithFrTimeZone() {
        Assertions.assertThat((String)ZonedDateTimeRepresentation.fromZonedDateTime((ZonedDateTime)ZONED_DATE_TIME_FR).getSerializedZoneId()).isEqualTo((Object)"+02:00");
    }

    @Test
    public void getDateShouldWorkWithFrTimeZone() {
        Assertions.assertThat((long)ZonedDateTimeRepresentation.fromZonedDateTime((ZonedDateTime)ZONED_DATE_TIME_FR).getDate().getTime()).isEqualTo(1460523880906L);
    }
}

