/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import org.apache.commons.lang.mutable.MutableInt;
import org.apache.james.backends.cassandra.utils.FunctionRunnerWithRetry;
import org.apache.james.backends.cassandra.utils.LightweightTransactionException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FunctionRunnerWithRetryTest {
    private static final int MAX_RETRY = 10;

    @Test(expected=IllegalArgumentException.class)
    public void functionRunnerWithInvalidMaxRetryShouldFail() throws Exception {
        new FunctionRunnerWithRetry(-1);
    }

    @Test(expected=LightweightTransactionException.class)
    public void functionRunnerShouldFailIfTransactionCanNotBePerformed() throws Exception {
        MutableInt value = new MutableInt(0);
        new FunctionRunnerWithRetry(10).execute(() -> {
            value.increment();
            return false;
        });
        Assertions.assertThat((Object)value.getValue()).isEqualTo((Object)10);
    }

    @Test
    public void functionRunnerShouldWorkOnFirstTry() throws Exception {
        MutableInt value = new MutableInt(0);
        new FunctionRunnerWithRetry(10).execute(() -> {
            value.increment();
            return true;
        });
        Assertions.assertThat((Object)value.getValue()).isEqualTo((Object)1);
    }

    @Test
    public void functionRunnerShouldWorkIfNotSucceededOnFirstTry() throws Exception {
        MutableInt value = new MutableInt(0);
        new FunctionRunnerWithRetry(10).execute(() -> {
            value.increment();
            return (Integer)value.getValue() == 5;
        });
        Assertions.assertThat((Object)value.getValue()).isEqualTo((Object)5);
    }

    @Test
    public void functionRunnerShouldWorkIfNotSucceededOnMaxRetryReached() throws Exception {
        MutableInt value = new MutableInt(0);
        new FunctionRunnerWithRetry(10).execute(() -> {
            value.increment();
            return (Integer)value.getValue() == 10;
        });
        Assertions.assertThat((Object)value.getValue()).isEqualTo((Object)10);
    }
}

