/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.components.CassandraIndex;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.components.CassandraType;
import org.apache.james.backends.cassandra.init.CassandraTypesCreator;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CassandraTypeProviderTest {
    private static final String TYPE_NAME = "typename";
    private static final String PROPERTY = "property";
    private CassandraCluster cassandra;
    private CassandraModule module;

    @Before
    public void setUp() {
        this.module = new CassandraModule(){

            public List<CassandraTable> moduleTables() {
                return ImmutableList.of();
            }

            public List<CassandraIndex> moduleIndex() {
                return ImmutableList.of();
            }

            public List<CassandraType> moduleTypes() {
                return ImmutableList.copyOf(Arrays.asList(new CassandraType(CassandraTypeProviderTest.TYPE_NAME, (CreateType)((CreateType)SchemaBuilder.createType((String)CassandraTypeProviderTest.TYPE_NAME).ifNotExists()).addColumn(CassandraTypeProviderTest.PROPERTY, DataType.text()))));
            }
        };
        this.cassandra = CassandraCluster.create(this.module);
        this.cassandra.getTypesProvider();
        this.cassandra.ensureAllTables();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void getDefinedUserTypeShouldNotReturnNullNorFailWhenTypeIsDefined() {
        Assertions.assertThat((Iterable)this.cassandra.getTypesProvider().getDefinedUserType(TYPE_NAME)).isNotNull();
    }

    @Test
    public void initializeTypesShouldCreateTheTypes() {
        this.deleteMailboxBaseType();
        new CassandraTypesCreator(this.module, this.cassandra.getConf()).initializeTypes();
        CassandraTypesProvider cassandraTypesProviderTest = new CassandraTypesProvider(this.module, this.cassandra.getConf());
        Assertions.assertThat((Iterable)cassandraTypesProviderTest.getDefinedUserType(TYPE_NAME)).isNotNull();
    }

    @Test
    public void initializeTypesShouldNotFailIfCalledTwice() {
        new CassandraTypesProvider(this.module, this.cassandra.getConf());
        Assertions.assertThat((Iterable)this.cassandra.getTypesProvider().getDefinedUserType(TYPE_NAME)).isNotNull();
    }

    private void deleteMailboxBaseType() {
        try {
            this.cassandra.getConf().execute((Statement)SchemaBuilder.dropType((String)TYPE_NAME));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assertions.fail((String)"Exception is thrown on Type deletion");
        }
    }
}

