/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.base.Throwables;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.EmbeddedCassandra;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.CassandraTableManager;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.ClusterFactory;
import org.apache.james.backends.cassandra.init.ClusterWithKeyspaceCreatedFactory;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.backends.cassandra.utils.FunctionRunnerWithRetry;

public final class CassandraCluster {
    private static final String CLUSTER_IP = "localhost";
    private static final int CLUSTER_PORT_TEST = 9142;
    private static final String KEYSPACE_NAME = "apache_james";
    private static final int REPLICATION_FACTOR = 1;
    private static final long SLEEP_BEFORE_RETRY = 200L;
    private static final int MAX_RETRY = 2000;
    private final CassandraModule module;
    private Session session;
    private CassandraTypesProvider typesProvider;

    public static CassandraCluster create(CassandraModule module) throws RuntimeException {
        return new CassandraCluster(module, EmbeddedCassandra.createStartServer());
    }

    @Inject
    private CassandraCluster(CassandraModule module, EmbeddedCassandra embeddedCassandra) throws RuntimeException {
        this.module = module;
        try {
            this.session = (Session)new FunctionRunnerWithRetry(2000).executeAndRetrieveObject(this::tryInitializeSession);
            this.typesProvider = new CassandraTypesProvider(module, this.session);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
    }

    public Session getConf() {
        return this.session;
    }

    public void ensureAllTables() {
        new CassandraTableManager(this.module, this.session).ensureAllTables();
    }

    @PreDestroy
    public void clearAllTables() {
        new CassandraTableManager(this.module, this.session).clearAllTables();
    }

    private Optional<Session> tryInitializeSession() {
        try {
            Cluster clusterWithInitializedKeyspace = ClusterWithKeyspaceCreatedFactory.config((Cluster)this.getCluster(), (String)KEYSPACE_NAME).replicationFactor(1).disableDurableWrites().clusterWithInitializedKeyspace();
            return Optional.of(new SessionWithInitializedTablesFactory(this.module).createSession(clusterWithInitializedKeyspace, KEYSPACE_NAME));
        }
        catch (NoHostAvailableException exception) {
            this.sleep(200L);
            return Optional.empty();
        }
    }

    public Cluster getCluster() {
        return ClusterFactory.createTestingCluster((String)CLUSTER_IP, (int)9142);
    }

    private void sleep(long sleepMs) {
        try {
            Thread.sleep(sleepMs);
        }
        catch (InterruptedException interruptedException) {
            Throwables.propagate((Throwable)interruptedException);
        }
    }

    public CassandraTypesProvider getTypesProvider() {
        return this.typesProvider;
    }
}

