/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.hooks;

import java.util.Calendar;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleHook
implements InstallHook {
    public static String PROP_COPY_FROM = "hook-example-copyfrom";
    public static String PROP_COPY_TO = "hook-example-copyto";
    public static String PROP_TEST_NODE = "hook-example-testnode";
    private String testNodePath;
    private static final Logger log = LoggerFactory.getLogger(ExampleHook.class);

    public void execute(InstallContext ctx) throws PackageException {
        log.info("Executing Hook in phase {}", (Object)ctx.getPhase());
        try {
            switch (ctx.getPhase()) {
                case END: {
                    this.doEnd(ctx);
                    break;
                }
                case INSTALLED: {
                    this.doInstalled(ctx);
                    break;
                }
                case INSTALL_FAILED: {
                    this.doInstallFailed(ctx);
                    break;
                }
                case PREPARE: {
                    this.doPrepare(ctx);
                    break;
                }
                case PREPARE_FAILED: {
                    this.doPrepareFailed(ctx);
                }
            }
        }
        catch (RepositoryException e) {
            throw new PackageException((Throwable)e);
        }
    }

    private void doPrepare(InstallContext ctx) throws PackageException, RepositoryException {
        Properties props = ctx.getPackage().getMetaInf().getProperties();
        String copyFrom = props.getProperty(PROP_COPY_FROM, "");
        if (copyFrom.length() == 0) {
            throw new PackageException("hook-example needs " + PROP_COPY_FROM + " property set in properties.xml");
        }
        String copyTo = props.getProperty(PROP_COPY_TO, "");
        if (copyTo.length() == 0) {
            throw new PackageException("hook-example needs " + PROP_COPY_TO + " property set in properties.xml");
        }
        this.testNodePath = props.getProperty(PROP_TEST_NODE, "");
        if (this.testNodePath.length() == 0) {
            throw new PackageException("hook-example needs " + PROP_TEST_NODE + " property set in properties.xml");
        }
        copyTo = copyTo + "_" + System.currentTimeMillis();
        ctx.getSession().getWorkspace().copy(copyFrom, copyTo);
        log.info("hook-example copied {} to {}", (Object)copyFrom, (Object)copyTo);
    }

    private void doPrepareFailed(InstallContext ctx) {
    }

    private void doEnd(InstallContext ctx) {
    }

    private void doInstalled(InstallContext ctx) throws RepositoryException {
        Node testNode = ctx.getSession().getNode(this.testNodePath);
        testNode.setProperty("hook-example", Calendar.getInstance());
        ctx.getSession().save();
    }

    private void doInstallFailed(InstallContext ctx) {
    }
}

