/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.AbstractRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRebaseDiffTest {
    private final NodeState base;

    public AbstractRebaseDiffTest() {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setChildNode("a");
        builder.setChildNode("b");
        builder.setChildNode("c");
        builder.setProperty("x", (Object)1);
        builder.setProperty("y", (Object)1);
        builder.setProperty("z", (Object)1);
        this.base = builder.getNodeState();
    }

    @Test
    public void addExistingProperty() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.setProperty("p", (Object)1);
        headBuilder.setProperty("p", (Object)1);
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.setProperty("p", (Object)1);
        branchBuilder.setProperty("p", (Object)0);
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void addExistingProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"p", (Object)0), (Object)after);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void changeDeletedProperty() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.removeProperty("x");
        headBuilder.removeProperty("y");
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.setProperty("x", (Object)1);
        branchBuilder.setProperty("y", (Object)0);
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void changeDeletedProperty(NodeBuilder builder, PropertyState after, PropertyState base) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"y", (Object)0), (Object)after);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void changeChangedProperty() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.setProperty("x", (Object)11);
        headBuilder.setProperty("y", (Object)22);
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.setProperty("x", (Object)11);
        branchBuilder.setProperty("y", (Object)0);
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void changeChangedProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"y", (Object)0), (Object)after);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void deleteDeletedProperty() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.removeProperty("x");
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.removeProperty("x");
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void deleteDeletedProperty(NodeBuilder builder, PropertyState before) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"x", (Object)1), (Object)before);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void deleteChangedProperty() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.setProperty("x", (Object)11);
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.removeProperty("x");
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void deleteChangedProperty(NodeBuilder builder, PropertyState before) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"x", (Object)1), (Object)before);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void addExistingNode() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.setChildNode("n");
        headBuilder.setChildNode("m").setChildNode("m1");
        headBuilder.getChildNode("m").setProperty("a", (Object)1);
        headBuilder.getChildNode("m").setProperty("p", (Object)1);
        headBuilder.getChildNode("m").setChildNode("mm").setChildNode("mm1");
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.setChildNode("n");
        branchBuilder.setChildNode("m").setChildNode("m2");
        branchBuilder.getChildNode("m").setProperty("a", (Object)1);
        branchBuilder.getChildNode("m").setProperty("q", (Object)1);
        branchBuilder.getChildNode("m").setChildNode("mm").setChildNode("mm2");
        NodeState branch = branchBuilder.getNodeState();
        NodeBuilder builder = head.builder();
        RebaseDiff rebaseDiff = new RebaseDiff(builder);
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        NodeBuilder expectedBuilder = this.base.builder();
        expectedBuilder.setChildNode("n");
        expectedBuilder.setChildNode("n");
        expectedBuilder.setChildNode("m").setChildNode("m1");
        expectedBuilder.getChildNode("m").setChildNode("m2");
        expectedBuilder.getChildNode("m").setProperty("a", (Object)1);
        expectedBuilder.getChildNode("m").setProperty("p", (Object)1);
        expectedBuilder.getChildNode("m").setProperty("q", (Object)1);
        expectedBuilder.getChildNode("m").setChildNode("mm").setChildNode("mm1");
        expectedBuilder.getChildNode("m").getChildNode("mm").setChildNode("mm2");
        Assert.assertEquals((Object)expectedBuilder.getNodeState(), (Object)builder.getNodeState());
    }

    @Test
    public void addExistingNodeWithConflict() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.setChildNode("n");
        headBuilder.setChildNode("m").setChildNode("m1");
        headBuilder.getChildNode("m").setProperty("p", (Object)1);
        headBuilder.getChildNode("m").setChildNode("mm").setChildNode("mmm").setProperty("pp", (Object)1);
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.setChildNode("n");
        branchBuilder.setChildNode("m").setChildNode("m2");
        branchBuilder.getChildNode("m").setProperty("q", (Object)1);
        branchBuilder.getChildNode("m").setChildNode("mm").setChildNode("mmm").setProperty("pp", (Object)2);
        NodeState branch = branchBuilder.getNodeState();
        NodeBuilder builder = head.builder();
        class ConflictResolver
        extends RebaseDiff {
            private final ConflictResolver parent;

            ConflictResolver(NodeBuilder builder) {
                this(null, builder);
            }

            public ConflictResolver(ConflictResolver parent, NodeBuilder builder) {
                super(builder);
                this.parent = parent;
            }

            @Override
            protected void resolve() {
                if (this.parent == null) {
                    super.resolve();
                } else {
                    this.parent.resolve();
                }
            }

            @Override
            protected AbstractRebaseDiff createDiff(NodeBuilder builder, String name) {
                return new ConflictResolver(this, builder.getChildNode(name));
            }

            @Override
            protected void addExistingProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"pp", (Object)1), (Object)before);
                Assert.assertEquals((Object)PropertyStates.createProperty((String)"pp", (Object)2), (Object)after);
                this.resolve();
            }
        }
        ConflictResolver rebaseDiff = new ConflictResolver(builder);
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void changeDeletedNode() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.getChildNode("a").remove();
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.getChildNode("a").setChildNode("aa");
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void changeDeletedNode(NodeBuilder builder, String name, NodeState after, NodeState base) {
                Assert.assertEquals((Object)"a", (Object)name);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void deleteDeletedNode() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.getChildNode("a").remove();
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.getChildNode("a").remove();
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void deleteDeletedNode(NodeBuilder builder, String name, NodeState before) {
                Assert.assertEquals((Object)"a", (Object)name);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    @Test
    public void deleteChangedNode() {
        NodeBuilder headBuilder = this.base.builder();
        headBuilder.getChildNode("a").setChildNode("aa");
        NodeState head = headBuilder.getNodeState();
        NodeBuilder branchBuilder = this.base.builder();
        branchBuilder.getChildNode("a").remove();
        NodeState branch = branchBuilder.getNodeState();
        RebaseDiff rebaseDiff = new RebaseDiff(head.builder()){

            @Override
            protected void deleteChangedNode(NodeBuilder builder, String name, NodeState before) {
                Assert.assertEquals((Object)"a", (Object)name);
                this.resolve();
            }
        };
        branch.compareAgainstBaseState(this.base, (NodeStateDiff)rebaseDiff);
        Assert.assertTrue((boolean)rebaseDiff.isResolved());
    }

    private static class RebaseDiff
    extends AbstractRebaseDiff {
        private boolean resolved;

        protected RebaseDiff(NodeBuilder builder) {
            super(builder);
        }

        protected void resolve() {
            this.resolved = true;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        protected AbstractRebaseDiff createDiff(NodeBuilder builder, String name) {
            return new RebaseDiff(builder.getChildNode(name));
        }

        protected void addExistingProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
            Assert.fail((String)("addExistingProperty " + after));
        }

        protected void changeDeletedProperty(NodeBuilder builder, PropertyState after, PropertyState base) {
            Assert.fail((String)("changeDeletedProperty " + after));
        }

        protected void changeChangedProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
            Assert.fail((String)("changeChangedProperty " + after));
        }

        protected void deleteDeletedProperty(NodeBuilder builder, PropertyState before) {
            Assert.fail((String)("deleteDeletedProperty " + before));
        }

        protected void deleteChangedProperty(NodeBuilder builder, PropertyState before) {
            Assert.fail((String)("deleteChangedProperty " + before));
        }

        protected void addExistingNode(NodeBuilder builder, String name, NodeState before, NodeState after) {
            Assert.fail((String)("addExistingNode " + name + '=' + after));
        }

        protected void changeDeletedNode(NodeBuilder builder, String name, NodeState after, NodeState base) {
            Assert.fail((String)("changeDeletedNode " + name + '=' + after));
        }

        protected void deleteDeletedNode(NodeBuilder builder, String name, NodeState before) {
            Assert.fail((String)("deleteDeletedNode " + name + '=' + before));
        }

        protected void deleteChangedNode(NodeBuilder builder, String name, NodeState before) {
            Assert.fail((String)("deleteChangedNode " + name + '=' + before));
        }
    }
}

