/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import junit.framework.Assert;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.junit.Test;

public class JsopDiffTest {
    @Test
    public void testPropertyChanges() {
        PropertyState before = StringPropertyState.stringProperty((String)"foo", (String)"bar");
        JsopDiff diff = new JsopDiff();
        diff.propertyAdded(before);
        Assert.assertEquals((String)"^\"/foo\":\"bar\"", (String)diff.toString());
        diff = new JsopDiff();
        diff.propertyChanged(before, LongPropertyState.createLongProperty((String)"foo", (long)123L));
        Assert.assertEquals((String)"^\"/foo\":123", (String)diff.toString());
        diff = new JsopDiff();
        diff.propertyChanged(before, DoublePropertyState.doubleProperty((String)"foo", (double)1.23));
        Assert.assertEquals((String)"^\"/foo\":1.23", (String)diff.toString());
        diff = new JsopDiff();
        diff.propertyChanged(before, BooleanPropertyState.booleanProperty((String)"foo", (boolean)true));
        Assert.assertEquals((String)"^\"/foo\":true", (String)diff.toString());
        diff = new JsopDiff();
        diff.propertyDeleted(before);
        Assert.assertEquals((String)"^\"/foo\":null", (String)diff.toString());
    }

    @Test
    public void testNodeChanges() {
        NodeState before = EmptyNodeState.EMPTY_NODE;
        NodeBuilder builder = before.builder();
        builder.setProperty("a", (Object)1L);
        builder.child("x");
        NodeState after = builder.getNodeState();
        JsopDiff diff = new JsopDiff();
        diff.childNodeAdded("test", before);
        Assert.assertEquals((String)"+\"/test\":{}", (String)diff.toString());
        diff = new JsopDiff();
        diff.childNodeChanged("test", before, after);
        Assert.assertEquals((String)"^\"/test/a\":1+\"/test/x\":{}", (String)diff.toString());
        diff = new JsopDiff();
        diff.childNodeDeleted("test", after);
        Assert.assertEquals((String)"-\"/test\"", (String)diff.toString());
    }
}

