/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.jetbrains.annotations.NotNull;

public abstract class EmptyPropertyState
extends AbstractPropertyState {
    private final String name;

    protected EmptyPropertyState(@NotNull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public static PropertyState emptyProperty(String name, final Type<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("Not an array type:" + type);
        }
        return new EmptyPropertyState(name){

            public Type<?> getType() {
                return type;
            }
        };
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return true;
    }

    @NotNull
    public <T> T getValue(Type<T> type) {
        Preconditions.checkArgument((boolean)type.isArray(), (Object)"Type must be an array type");
        return (T)Collections.emptyList();
    }

    @NotNull
    public <T> T getValue(Type<T> type, int index) {
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public long size() {
        throw new IllegalStateException("Not a single valued property");
    }

    public long size(int index) {
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public int count() {
        return 0;
    }
}

