/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MoveTrackerTest {
    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)new MoveTracker().isEmpty());
    }

    @Test
    public void test1() {
        MoveTracker mt = new MoveTracker();
        mt.addMove("/a", "/b");
        mt.addMove("/c", "/d");
        Assert.assertEquals((Object)"/a", (Object)mt.getSourcePath("/b"));
        Assert.assertEquals((Object)"/c", (Object)mt.getSourcePath("/d"));
        Assert.assertEquals((Object)"/b", (Object)mt.getDestPath("/a"));
        Assert.assertEquals((Object)"/d", (Object)mt.getDestPath("/c"));
    }

    @Test
    public void test4() {
        MoveTracker mt1 = new MoveTracker();
        mt1.addMove("/a/b", "/c");
        mt1.addMove("/a", "/d");
        Assert.assertEquals((Object)"/a/b", (Object)mt1.getSourcePath("/c"));
        Assert.assertEquals((Object)"/a", (Object)mt1.getSourcePath("/d"));
        Assert.assertEquals((Object)"/c", (Object)mt1.getDestPath("/a/b"));
        Assert.assertEquals((Object)"/d", (Object)mt1.getDestPath("/a"));
    }

    @Test
    public void test4a() {
        MoveTracker mt2 = new MoveTracker();
        mt2.addMove("/a/b", "/c");
        mt2.addMove("/a", "/c/d");
        Assert.assertEquals((Object)"/a/b", (Object)mt2.getSourcePath("/c"));
        Assert.assertEquals((Object)"/a", (Object)mt2.getSourcePath("/c/d"));
        Assert.assertEquals((Object)"/c", (Object)mt2.getDestPath("/a/b"));
        Assert.assertEquals((Object)"/c/d", (Object)mt2.getDestPath("/a"));
    }

    @Test
    public void test7() {
        MoveTracker mt3 = new MoveTracker();
        mt3.addMove("/a", "/b");
        mt3.addMove("/c", "/a");
        Assert.assertEquals((Object)"/a", (Object)mt3.getSourcePath("/b"));
        Assert.assertEquals((Object)"/c", (Object)mt3.getSourcePath("/a"));
        Assert.assertEquals((Object)"/b", (Object)mt3.getDestPath("/a"));
        Assert.assertEquals((Object)"/a", (Object)mt3.getDestPath("/c"));
    }

    @Test
    public void test10() {
        MoveTracker mt = new MoveTracker();
        mt.addMove("/a", "/b");
        mt.addMove("/b/c", "/d");
        Assert.assertEquals((Object)"/a", (Object)mt.getSourcePath("/b"));
        Assert.assertEquals((Object)"/a/c", (Object)mt.getSourcePath("/d"));
        Assert.assertEquals((Object)"/b", (Object)mt.getDestPath("/a"));
        Assert.assertEquals((Object)"/d", (Object)mt.getDestPath("/a/c"));
    }

    @Test
    public void test11() {
        MoveTracker mt = new MoveTracker();
        mt.addMove("/a", "/b");
        mt.addMove("/b", "/c");
        Assert.assertEquals((Object)"/a", (Object)mt.getSourcePath("/c"));
        Assert.assertEquals((Object)"/c", (Object)mt.getDestPath("/a"));
    }

    @Test
    @Ignore(value="Known Limitation of OAK-710")
    public void test12() {
        MoveTracker mt4 = new MoveTracker();
        mt4.addMove("/a", "/b/c");
        mt4.addMove("/b", "/d");
        Assert.assertEquals((Object)"/a", (Object)mt4.getSourcePath("/d/c"));
        Assert.assertEquals((Object)"/b", (Object)mt4.getSourcePath("/d"));
        Assert.assertEquals((Object)"/d/c", (Object)mt4.getDestPath("/a"));
        Assert.assertEquals((Object)"/d", (Object)mt4.getDestPath("/b"));
    }

    @Test
    public void test14() {
        MoveTracker mt5 = new MoveTracker();
        mt5.addMove("/a", "/b");
        mt5.addMove("/c", "/b/d");
        Assert.assertEquals((Object)"/a", (Object)mt5.getSourcePath("/b"));
        Assert.assertEquals((Object)"/c", (Object)mt5.getSourcePath("/b/d"));
        Assert.assertEquals((Object)"/b", (Object)mt5.getDestPath("/a"));
        Assert.assertEquals((Object)"/b/d", (Object)mt5.getDestPath("/c"));
    }

    @Test
    public void test14a() {
        MoveTracker mt6 = new MoveTracker();
        mt6.addMove("/a/b", "/b");
        mt6.addMove("/a", "/b/d");
        Assert.assertEquals((Object)"/a/b", (Object)mt6.getSourcePath("/b"));
        Assert.assertEquals((Object)"/a", (Object)mt6.getSourcePath("/b/d"));
        Assert.assertEquals((Object)"/b", (Object)mt6.getDestPath("/a/b"));
        Assert.assertEquals((Object)"/b/d", (Object)mt6.getDestPath("/a"));
    }

    @Test
    public void testNotEmpty() {
        MoveTracker mt = new MoveTracker();
        mt.addMove("/a/b/c", "/d/e/f");
        Assert.assertFalse((boolean)mt.isEmpty());
    }

    @Test
    public void testSingleMove() {
        ImmutableMap moves = ImmutableMap.of((Object)"/a/b/c", (Object)"/d/e/f", (Object)"/aa/bb/cc", (Object)"/aa/f/cc");
        for (String src : moves.keySet()) {
            MoveTracker mt = new MoveTracker();
            String dest = (String)moves.get(src);
            mt.addMove(src, dest);
            Assert.assertEquals((Object)src, (Object)mt.getSourcePath(dest));
            Assert.assertEquals((Object)dest, (Object)mt.getDestPath(src));
        }
    }

    @Test
    public void testIndependantMoves() {
        String dest;
        ImmutableMap m = ImmutableMap.of((Object)"/a/b/c", (Object)"/d/e/f", (Object)"/aa/bb/cc", (Object)"/aa/f/cc");
        MoveTracker mt = new MoveTracker();
        for (String src : m.keySet()) {
            dest = (String)m.get(src);
            mt.addMove(src, dest);
        }
        for (String src : m.keySet()) {
            dest = (String)m.get(src);
            Assert.assertEquals((Object)src, (Object)mt.getSourcePath(dest));
            Assert.assertEquals((Object)dest, (Object)mt.getDestPath(src));
        }
    }

    @Test
    public void testMultiMove() {
        MoveTest test = new MoveTest().addMove("/a/b/c", "/a/f/c", "/a/b/c").addMove("/a/f/c/d", "/a/b/d", "/a/b/c/d").addMove("/a/b/d/e", "/a/f/c/e", "/a/b/c/d/e");
        test.assertResult();
    }

    @Test
    public void testMultiMove2() {
        MoveTest test = new MoveTest().addMove("/a/b/c", "/a/f/c", "/a/b/c").addMove("/a/f/c/d", "/a/b/d", "/a/b/c/d").addMove("/a/b/d/e", "/a/f/c/e", "/a/b/c/d/e").addMove("/a/f/c/e", "/a/f/e", "/a/b/c/d/e");
        test.assertResult();
    }

    @Test
    public void testMultiMove3() {
        MoveTest test = new MoveTest().addMove("/a/b/c", "/a/f/c", "/a/b/c").addMove("/a/f/c/d", "/a/b/d", "/a/b/c/d").addMove("/a/b/d/e", "/a/f/c/e", "/a/b/c/d/e").addMove("/a/f/c/e", "/a/b/c", "/a/b/c/d/e");
        test.assertResult();
        test.addMove("/a/b/d", "/a/b/c/d", "/a/b/c/d");
        test.assertResult();
    }

    @Test
    public void testMultiMove4() {
        MoveTest test = new MoveTest().addMove("/a/b/c", "/a/f/c", "/a/b/c").addMove("/a/f/c/d", "/a/b/d", "/a/b/c/d").addMove("/a/b/d/e", "/a/f/c/e", "/a/b/c/d/e").addMove("/a/f/c", "/a/b/d/e", "/a/b/c");
        test.assertResult();
    }

    @Test
    public void testMultiMoveIncludingNewNodes() {
        MoveTest test = new MoveTest().addMove("/a/b/c", "/a/f/c", "/a/b/c").addMove("/a/f/c/d", "/a/b/d", "/a/b/c/d").addMove("/a/b/d/e", "/a/f/c/e", "/a/b/c/d/e").addMove("/a/b/d/e", "/a/b/c/d/e", "/a/b/c/d/e");
        test.assertResult();
    }

    private static final class MoveTest {
        private final Map<String, String> src2dest = new LinkedHashMap<String, String>();
        private final Map<String, String> dest2orig = new LinkedHashMap<String, String>();
        private final Map<String, String> orig2dest = new LinkedHashMap<String, String>();
        MoveTracker mt = new MoveTracker();

        private MoveTest() {
        }

        MoveTest addMove(String src, String dst, String originalSrc) {
            this.src2dest.put(src, dst);
            this.dest2orig.put(dst, originalSrc);
            this.orig2dest.put(originalSrc, dst);
            this.mt.addMove(src, dst);
            return this;
        }

        void assertResult() {
            for (String dest : this.src2dest.values()) {
                String expectedOrgSource = this.dest2orig.get(dest);
                Assert.assertEquals((Object)expectedOrgSource, (Object)this.mt.getSourcePath(dest));
            }
            for (String original : this.orig2dest.keySet()) {
                Assert.assertEquals((Object)this.orig2dest.get(original), (Object)this.mt.getDestPath(original));
            }
        }
    }
}

