/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.junit.Assert;
import org.junit.Test;

public class JsonSerializerTest {
    @Test
    public void childOrder() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.child("a");
        builder.child("b");
        builder.child("c");
        List<String> expectedOrder = Arrays.asList("a", "c", "b");
        builder.setProperty(":childOrder", expectedOrder, Type.NAMES);
        NodeState state = builder.getNodeState();
        String json = this.serialize(state);
        JsopTokenizer reader = new JsopTokenizer(json);
        ArrayList childNames = Lists.newArrayList();
        reader.read(123);
        do {
            String key = reader.readString();
            reader.read(58);
            if (!reader.matches(123)) continue;
            childNames.add(key);
            reader.matches(125);
        } while (reader.matches(44));
        Assert.assertEquals(expectedOrder, (Object)childNames);
    }

    private String serialize(NodeState nodeState) {
        JsopBuilder json = new JsopBuilder();
        new JsonSerializer((JsopWriter)json, "{\"properties\":[\"*\", \"-:*\"]}", new BlobSerializer()).serialize(nodeState);
        return json.toString();
    }
}

