/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import junit.framework.Assert;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemoryNodeBuilderTest {
    private final NodeState base;

    public MemoryNodeBuilderTest(NodeState base) {
        this.base = base;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> fixtures() {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setProperty("a", (Object)1L);
        builder.setProperty("b", (Object)2L);
        builder.setProperty("c", (Object)3L);
        builder.child("x").child("q");
        builder.child("y");
        builder.child("z");
        NodeState base = builder.getNodeState();
        return ImmutableList.of((Object)new Object[]{base}, (Object)new Object[]{ModifiedNodeState.squeeze((NodeState)base)});
    }

    @Test
    public void testConnectOnAddProperty() {
        NodeBuilder root = this.base.builder();
        NodeBuilder childA = root.child("x");
        NodeBuilder childB = root.child("x");
        Assert.assertFalse((boolean)childA.hasProperty("test"));
        childB.setProperty("test", (Object)"foo");
        Assert.assertTrue((boolean)childA.hasProperty("test"));
    }

    @Test
    public void testConnectOnUpdateProperty() {
        NodeBuilder root = this.base.builder();
        NodeBuilder childA = root.child("x");
        NodeBuilder childB = root.child("x");
        childB.setProperty("test", (Object)"foo");
        childA.setProperty("test", (Object)"bar");
        Assert.assertEquals((String)"bar", (String)((String)childA.getProperty("test").getValue(Type.STRING)));
        Assert.assertEquals((String)"bar", (String)((String)childB.getProperty("test").getValue(Type.STRING)));
    }

    @Test
    public void testConnectOnRemoveProperty() {
        NodeBuilder root = this.base.builder();
        NodeBuilder childA = root.child("x");
        NodeBuilder childB = root.child("x");
        childB.setProperty("test", (Object)"foo");
        childA.removeProperty("test");
        Assert.assertFalse((boolean)childA.hasProperty("test"));
        Assert.assertFalse((boolean)childB.hasProperty("test"));
        childA.setProperty("test", (Object)"bar");
        Assert.assertEquals((String)"bar", (String)((String)childA.getProperty("test").getValue(Type.STRING)));
        Assert.assertEquals((String)"bar", (String)((String)childB.getProperty("test").getValue(Type.STRING)));
    }

    @Test
    public void testConnectOnAddNode() {
        NodeBuilder root = this.base.builder();
        NodeBuilder childA = root.child("x");
        NodeBuilder childB = root.child("x");
        Assert.assertFalse((boolean)childA.hasChildNode("test"));
        Assert.assertFalse((boolean)childB.hasChildNode("test"));
        childB.child("test");
        Assert.assertTrue((boolean)childA.hasChildNode("test"));
        Assert.assertTrue((boolean)childB.hasChildNode("test"));
    }

    @Test
    public void testWriteOnRemoveNode() {
        for (String name : new String[]{"x", "new"}) {
            NodeBuilder root = this.base.builder();
            NodeBuilder child = root.child(name);
            root.getChildNode(name).remove();
            try {
                child.setProperty("q", (Object)"w");
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            root.child(name);
            Assert.assertEquals((long)0L, (long)child.getChildNodeCount(1L));
        }
    }

    @Test
    public void testAddRemovedNodeAgain() {
        NodeBuilder root = this.base.builder();
        root.getChildNode("x").remove();
        NodeBuilder x = root.child("x");
        x.child("q");
        Assert.assertTrue((boolean)x.hasChildNode("q"));
    }

    @Test
    public void testReset() {
        NodeBuilder root = this.base.builder();
        NodeBuilder child = root.child("x");
        child.child("new");
        Assert.assertTrue((boolean)child.hasChildNode("new"));
        Assert.assertTrue((boolean)root.child("x").hasChildNode("new"));
        ((MemoryNodeBuilder)root).reset(this.base);
        Assert.assertFalse((boolean)child.hasChildNode("new"));
        Assert.assertFalse((boolean)root.child("x").hasChildNode("new"));
    }

    @Test
    public void testReset2() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.child("x");
        x.child("y");
        ((MemoryNodeBuilder)root).reset(this.base);
        Assert.assertTrue((boolean)root.hasChildNode("x"));
        Assert.assertFalse((boolean)x.hasChildNode("y"));
    }

    @Test
    public void testUnmodifiedEqualsBase() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.child("x");
        Assert.assertEquals((Object)x.getBaseState(), (Object)x.getNodeState());
    }

    @Test
    public void transitiveRemove() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.getChildNode("x");
        NodeBuilder q = x.getChildNode("q");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)q.exists());
        root.getChildNode("x").remove();
        Assert.assertFalse((boolean)q.exists());
        Assert.assertFalse((boolean)x.exists());
    }

    @Test
    public void testExistingStatus() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.child("x");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertFalse((boolean)x.isNew());
        Assert.assertFalse((boolean)x.isModified());
    }

    @Test
    public void testModifiedStatus() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.child("x");
        x.setProperty("p", (Object)"pValue");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertFalse((boolean)x.isNew());
        Assert.assertTrue((boolean)x.isModified());
    }

    @Test
    public void testReplacedStatus() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.getChildNode("x");
        x.setChildNode("new");
        Assert.assertFalse((boolean)x.isReplaced());
    }

    @Test
    public void testReplacedStatus2() {
        NodeBuilder x = this.base.builder().getChildNode("x");
        NodeBuilder q = x.getChildNode("q");
        q.remove();
        Assert.assertFalse((boolean)q.isReplaced());
        x.setChildNode("q").setProperty("a", (Object)"b");
        Assert.assertTrue((boolean)q.isReplaced());
    }

    @Test
    public void testReplacedStatus3() {
        NodeBuilder x = this.base.builder().getChildNode("x");
        NodeBuilder q = x.getChildNode("q");
        Assert.assertFalse((boolean)q.isReplaced());
        x.setChildNode("q").setProperty("a", (Object)"b");
        Assert.assertTrue((boolean)q.isReplaced());
    }

    @Test
    public void removeParent() {
        NodeBuilder x = this.base.builder().getChildNode("x");
        NodeBuilder y = x.setChildNode("y");
        x.remove();
        Assert.assertFalse((boolean)x.exists());
    }

    @Test
    public void testRemovedStatus() {
        NodeBuilder root = this.base.builder();
        NodeBuilder x = root.child("x");
        root.getChildNode("x").remove();
        Assert.assertFalse((boolean)x.exists());
        Assert.assertFalse((boolean)x.isNew());
        Assert.assertFalse((boolean)x.isModified());
    }

    @Test
    public void testNewStatus() {
        NodeBuilder root = this.base.builder();
        NodeBuilder n = root.child("n");
        Assert.assertTrue((boolean)n.exists());
        Assert.assertTrue((boolean)n.isNew());
        Assert.assertFalse((boolean)n.isModified());
    }

    @Test
    public void getExistingChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder x = rootBuilder.getChildNode("x");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)x.getNodeState().exists());
    }

    @Test
    public void getNonExistingChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder any = rootBuilder.getChildNode("any");
        Assert.assertFalse((boolean)any.getChildNode("other").exists());
        Assert.assertFalse((boolean)any.exists());
        try {
            any.setChildNode("any");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void addExistingChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder x = rootBuilder.setChildNode("x");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)x.getBaseState().exists());
    }

    @Test
    public void addNewChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder x = rootBuilder.setChildNode("any");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)x.getNodeState().exists());
    }

    @Test
    public void existingChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder x = rootBuilder.child("x");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)x.getBaseState().exists());
    }

    @Test
    public void newChildTest() {
        NodeBuilder rootBuilder = this.base.builder();
        NodeBuilder x = rootBuilder.child("any");
        Assert.assertTrue((boolean)x.exists());
        Assert.assertTrue((boolean)x.getNodeState().exists());
    }

    @Test
    public void setNodeTest() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.setChildNode("a", MemoryNodeBuilderTest.createBC(true));
        NodeState c = rootBuilder.getNodeState().getChildNode("a").getChildNode("c");
        Assert.assertTrue((boolean)c.hasProperty("c"));
        rootBuilder.child("a").child("c").setProperty("c2", (Object)"c2Value");
        c = rootBuilder.getNodeState().getChildNode("a").getChildNode("c");
        Assert.assertTrue((boolean)c.hasProperty("c"));
        Assert.assertTrue((boolean)c.hasProperty("c2"));
    }

    @Test
    public void setTest() {
        Assume.assumeTrue((boolean)(EmptyNodeState.EMPTY_NODE.builder() instanceof MemoryNodeBuilder));
        MemoryNodeBuilder rootBuilder = (MemoryNodeBuilder)EmptyNodeState.EMPTY_NODE.builder();
        Assert.assertFalse((boolean)this.base.equals(rootBuilder.getNodeState()));
        rootBuilder.set(this.base);
        Assert.assertTrue((boolean)this.base.equals(rootBuilder.getNodeState()));
        MemoryNodeBuilder xBuilder = (MemoryNodeBuilder)rootBuilder.getChildNode("x");
        NodeState yState = this.base.getChildNode("y");
        Assert.assertFalse((boolean)yState.equals(xBuilder.getNodeState()));
        xBuilder.set(yState);
        Assert.assertTrue((boolean)yState.equals(xBuilder.getNodeState()));
    }

    @Test
    public void testMove() {
        NodeBuilder rootBuilder = this.base.builder();
        Assert.assertTrue((boolean)rootBuilder.getChildNode("y").moveTo(rootBuilder.child("x"), "yy"));
        NodeState newRoot = rootBuilder.getNodeState();
        Assert.assertFalse((boolean)newRoot.hasChildNode("y"));
        Assert.assertTrue((boolean)newRoot.hasChildNode("x"));
        Assert.assertTrue((boolean)newRoot.getChildNode("x").hasChildNode("q"));
        Assert.assertTrue((boolean)newRoot.getChildNode("x").hasChildNode("yy"));
    }

    @Test
    public void testRename() {
        NodeBuilder rootBuilder = this.base.builder();
        Assert.assertTrue((boolean)rootBuilder.getChildNode("y").moveTo(rootBuilder, "yy"));
        NodeState newRoot = rootBuilder.getNodeState();
        Assert.assertFalse((boolean)newRoot.hasChildNode("y"));
        Assert.assertTrue((boolean)newRoot.hasChildNode("yy"));
    }

    @Test
    public void testMoveToSelf() {
        NodeBuilder rootBuilder = this.base.builder();
        Assert.assertFalse((boolean)rootBuilder.getChildNode("y").moveTo(rootBuilder, "y"));
        NodeState newRoot = rootBuilder.getNodeState();
        Assert.assertTrue((boolean)newRoot.hasChildNode("y"));
    }

    @Test
    public void testMoveToDescendant() {
        NodeBuilder rootBuilder = this.base.builder();
        Assert.assertTrue((boolean)rootBuilder.getChildNode("x").moveTo(rootBuilder.getChildNode("x"), "xx"));
        Assert.assertFalse((boolean)rootBuilder.hasChildNode("x"));
    }

    @Test
    public void assertion_OAK781() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.child("a").setChildNode("b", MemoryNodeBuilderTest.createBC(false));
        NodeState r = rootBuilder.getNodeState();
        NodeState a = r.getChildNode("a");
        NodeState b = a.getChildNode("b");
        NodeState c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        rootBuilder.child("a").child("b").child("c");
        rootBuilder = new MemoryNodeBuilder(r);
        rootBuilder.child("a").child("b").child("c");
    }

    @Test
    public void modifyChildNodeOfNonExistingNode() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.child("a").setChildNode("b", MemoryNodeBuilderTest.createBC(false));
        NodeState r = rootBuilder.getNodeState();
        NodeState a = r.getChildNode("a");
        NodeState b = a.getChildNode("b");
        NodeState c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        rootBuilder.child("a").getChildNode("b").child("c").setProperty("c2", (Object)"c2Value");
        r = rootBuilder.getNodeState();
        a = r.getChildNode("a");
        b = a.getChildNode("b");
        c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        Assert.assertTrue((boolean)c.hasProperty("c2"));
    }

    @Test
    public void shadowNonExistingNode1() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.child("a").setChildNode("b", MemoryNodeBuilderTest.createBC(false));
        NodeState r = rootBuilder.getNodeState();
        NodeState a = r.getChildNode("a");
        NodeState b = a.getChildNode("b");
        NodeState c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        rootBuilder.child("a").setChildNode("b").child("c").setProperty("c2", (Object)"c2Value");
        r = rootBuilder.getNodeState();
        a = r.getChildNode("a");
        b = a.getChildNode("b");
        c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertTrue((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertFalse((boolean)c.hasProperty("c"));
        Assert.assertTrue((boolean)c.hasProperty("c2"));
    }

    @Test
    public void shadowNonExistingNode2() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.child("a").setChildNode("b", MemoryNodeBuilderTest.createBC(false));
        NodeState r = rootBuilder.getNodeState();
        NodeState a = r.getChildNode("a");
        NodeState b = a.getChildNode("b");
        NodeState c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        rootBuilder.child("a").child("b").child("c").setProperty("c2", (Object)"c2Value");
        r = rootBuilder.getNodeState();
        a = r.getChildNode("a");
        b = a.getChildNode("b");
        c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertTrue((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertFalse((boolean)c.hasProperty("c"));
        Assert.assertTrue((boolean)c.hasProperty("c2"));
    }

    @Test
    public void navigateNonExistingNode() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        rootBuilder.child("a").setChildNode("b", MemoryNodeBuilderTest.createBC(false));
        NodeState r = rootBuilder.getNodeState();
        NodeState a = r.getChildNode("a");
        NodeState b = a.getChildNode("b");
        NodeState c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        NodeBuilder aBuilder = rootBuilder.getChildNode("a");
        NodeBuilder bBuilder = aBuilder.getChildNode("b");
        NodeBuilder cBuilder = bBuilder.getChildNode("c");
        Assert.assertTrue((boolean)aBuilder.exists());
        Assert.assertTrue((boolean)cBuilder.exists());
        cBuilder.setProperty("c2", (Object)"c2Value");
        r = rootBuilder.getNodeState();
        a = r.getChildNode("a");
        b = a.getChildNode("b");
        c = b.getChildNode("c");
        Assert.assertTrue((boolean)a.exists());
        Assert.assertFalse((boolean)b.exists());
        Assert.assertTrue((boolean)c.exists());
        Assert.assertTrue((boolean)c.hasProperty("c"));
        Assert.assertTrue((boolean)c.hasProperty("c2"));
    }

    @Test
    public void removeRoot() {
        Assert.assertFalse((boolean)this.base.builder().remove());
    }

    private static NodeState createBC(final boolean exists) {
        final NodeState C = new MemoryNodeBuilder(EmptyNodeState.EMPTY_NODE).setProperty("c", (Object)"cValue").getNodeState();
        return new AbstractNodeState(){

            public boolean exists() {
                return exists;
            }

            @NotNull
            public Iterable<? extends PropertyState> getProperties() {
                return ImmutableSet.of();
            }

            public boolean hasChildNode(@NotNull String name) {
                return "c".equals(name);
            }

            @NotNull
            public NodeState getChildNode(@NotNull String name) {
                if ("c".equals(name)) {
                    return C;
                }
                1.checkValidName((String)name);
                return EmptyNodeState.MISSING_NODE;
            }

            @NotNull
            public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
                if (exists) {
                    return ImmutableSet.of((Object)new MemoryChildNodeEntry("c", C));
                }
                return ImmutableSet.of();
            }

            @NotNull
            public NodeBuilder builder() {
                return new MemoryNodeBuilder((NodeState)this);
            }
        };
    }
}

