/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value.jcr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.JackrabbitValue;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.IllegalRepositoryStateException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.ErrorValue;
import org.apache.jackrabbit.oak.plugins.value.OakValue;
import org.apache.jackrabbit.oak.plugins.value.jcr.BinaryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueImpl
implements JackrabbitValue,
OakValue {
    private static final Logger LOG = LoggerFactory.getLogger(ValueImpl.class);
    private final PropertyState propertyState;
    private final Type<?> type;
    private final int index;
    private final NamePathMapper namePathMapper;
    private InputStream stream = null;

    ValueImpl(@Nonnull PropertyState property, int index, @Nonnull NamePathMapper namePathMapper) throws RepositoryException {
        Preconditions.checkArgument((index < property.count() ? 1 : 0) != 0);
        this.propertyState = (PropertyState)Preconditions.checkNotNull((Object)property);
        this.type = this.getType(property);
        this.index = index;
        this.namePathMapper = (NamePathMapper)Preconditions.checkNotNull((Object)namePathMapper);
    }

    ValueImpl(@Nonnull PropertyState property, @Nonnull NamePathMapper namePathMapper) throws RepositoryException {
        this(ValueImpl.checkSingleValued(property), 0, namePathMapper);
    }

    private static PropertyState checkSingleValued(PropertyState property) {
        Preconditions.checkArgument((!property.isArray() ? 1 : 0) != 0);
        return property;
    }

    @Nonnull
    static Value newValue(@Nonnull PropertyState property, int index, @Nonnull NamePathMapper namePathMapper) {
        try {
            return new ValueImpl(property, index, namePathMapper);
        }
        catch (RepositoryException e) {
            return new ErrorValue(e);
        }
    }

    @Nonnull
    static Value newValue(@Nonnull PropertyState property, @Nonnull NamePathMapper namePathMapper) {
        try {
            return new ValueImpl(property, 0, namePathMapper);
        }
        catch (RepositoryException e) {
            return new ErrorValue(e);
        }
    }

    @Override
    public Blob getBlob() throws RepositoryException {
        return (Blob)this.getValue(Type.BINARY, this.index);
    }

    @Override
    public String getOakString() throws RepositoryException {
        return (String)this.getValue(Type.STRING, this.index);
    }

    public int getType() {
        return this.type.tag();
    }

    public boolean getBoolean() throws RepositoryException {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 6: {
                return (Boolean)this.getValue(Type.BOOLEAN, this.index);
            }
        }
        throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
    }

    public Calendar getDate() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 5: {
                    String value = (String)this.getValue(Type.DATE, this.index);
                    return Conversions.convert(value).toCalendar();
                }
                case 3: 
                case 4: 
                case 12: {
                    return Conversions.convert((Long)this.getValue(Type.LONG, this.index)).toCalendar();
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to date", (Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return (BigDecimal)this.getValue(Type.DECIMAL, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to decimal", (Throwable)e);
        }
    }

    public double getDouble() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return (Double)this.getValue(Type.DOUBLE, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to double", (Throwable)e);
        }
    }

    public long getLong() throws RepositoryException {
        try {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    return (Long)this.getValue(Type.LONG, this.index);
                }
            }
            throw new ValueFormatException("Incompatible type " + PropertyType.nameFromValue((int)this.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Error converting value to long", (Throwable)e);
        }
    }

    public String getString() throws RepositoryException {
        Preconditions.checkState((this.getType() != 2 || this.stream == null ? 1 : 0) != 0, (Object)"getStream has previously been called on this Value instance. In this case a new Value instance must be acquired in order to successfully call this method.");
        switch (this.getType()) {
            case 7: {
                return this.namePathMapper.getJcrName(this.getOakString());
            }
            case 8: {
                String s = this.getOakString();
                if (s.startsWith("[") && s.endsWith("]")) {
                    return s;
                }
                return this.namePathMapper.getJcrPath(s);
            }
        }
        return this.getOakString();
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        if (this.stream == null) {
            this.stream = this.getBlob().getNewStream();
        }
        return this.stream;
    }

    public Binary getBinary() throws RepositoryException {
        return new BinaryImpl(this);
    }

    public String getContentIdentity() {
        try {
            return this.getBlob().getContentIdentity();
        }
        catch (RepositoryException e) {
            LOG.warn("Error getting content identity", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ValueImpl) {
            Type thatType;
            ValueImpl that = (ValueImpl)other;
            Type thisType = this.type;
            if (thisType.isArray()) {
                thisType = thisType.getBaseType();
            }
            if ((thatType = that.type).isArray()) {
                thatType = thatType.getBaseType();
            }
            try {
                return thisType == thatType && Objects.equal(this.getValue(thatType, this.index), that.getValue(thatType, that.index));
            }
            catch (RepositoryException e) {
                LOG.warn("Error while comparing values", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            if (this.getType() == 2) {
                return ((Blob)this.getValue(Type.BINARY, this.index)).hashCode();
            }
            return ((String)this.getValue(Type.STRING, this.index)).hashCode();
        }
        catch (RepositoryException e) {
            LOG.warn("Error while calculating hash code", (Throwable)e);
            return 0;
        }
    }

    public String toString() {
        try {
            return (String)this.getValue(Type.STRING, this.index);
        }
        catch (RepositoryException e) {
            return e.toString();
        }
    }

    private <T> T getValue(Type<T> type, int index) throws RepositoryException {
        try {
            return (T)this.propertyState.getValue(type, index);
        }
        catch (IllegalRepositoryStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Type<?> getType(PropertyState property) throws RepositoryException {
        try {
            return this.propertyState.getType();
        }
        catch (IllegalRepositoryStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

