/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.util.ISO8601;
import org.junit.Assert;
import org.junit.Test;

public class PropertyStateValueTest {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final TimeZone CET = TimeZone.getTimeZone("CET");
    private static final TimeZone PST = TimeZone.getTimeZone("PST");

    @Test
    public void compareDates() {
        Calendar d1 = PropertyStateValueTest.newCal(null);
        Calendar d2 = PropertyStateValueTest.newCal(d1);
        PropertyValue v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        PropertyValue v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v1.compareTo((Object)v2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v2.compareTo((Object)v1));
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, GMT, 1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 < v2", (v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 > v1", (v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, GMT, -1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 > v2", (v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 < v1", (v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null, PST, 0);
        d2 = PropertyStateValueTest.newCal(d1, PST, 0);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v1.compareTo((Object)v2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v2.compareTo((Object)v1));
        d1 = PropertyStateValueTest.newCal(null, PST, 0);
        d2 = PropertyStateValueTest.newCal(d1, PST, 1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 < v2", (v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 > v1", (v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null, PST, 0);
        d2 = PropertyStateValueTest.newCal(d1, PST, -1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 > v2", (v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 < v1", (v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, CET, 0);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v1.compareTo((Object)v2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v2.compareTo((Object)v1));
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, CET, 1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 < v2", (v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 > v1", (v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, CET, -1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 > v2", (v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 < v1", (v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, PST, 0);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v1.compareTo((Object)v2));
        Assert.assertEquals((String)"v1 and v2 should be equals", (long)0L, (long)v2.compareTo((Object)v1));
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, PST, 1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 < v2", (v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 > v1", (v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        d1 = PropertyStateValueTest.newCal(null);
        d2 = PropertyStateValueTest.newCal(d1, PST, -1);
        v1 = PropertyValues.newDate((String)ISO8601.format((Calendar)d1));
        v2 = PropertyValues.newDate((String)ISO8601.format((Calendar)d2));
        Assert.assertTrue((String)"v1 > v2", (v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"v2 < v1", (v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
    }

    private static Calendar newCal(@Nullable Calendar start) {
        return PropertyStateValueTest.newCal(start, null, 0);
    }

    private static Calendar newCal(@Nullable Calendar start, @Nullable TimeZone tz, int hoursOffset) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(tz == null ? GMT : tz);
        if (start == null) {
            return c;
        }
        c.setTime(start.getTime());
        c.add(11, hoursOffset);
        return c;
    }
}

