/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ObserverTrackerTest {
    private final Set<Observer> observers = Sets.newHashSet();
    private final Observable observable = new Observable(){

        public Closeable addObserver(final Observer observer) {
            ObserverTrackerTest.this.observers.add(observer);
            return new Closeable(){

                @Override
                public void close() {
                    if (!ObserverTrackerTest.this.observers.remove(observer)) {
                        Assert.fail((String)"Already closed");
                    }
                }
            };
        }
    };
    private final ObserverTracker tracker = new ObserverTracker(this.observable);
    private final ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final Observer observer1 = (Observer)Mockito.mock(Observer.class);
    private final ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final Observer observer2 = (Observer)Mockito.mock(Observer.class);

    @Before
    public void setup() {
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        Mockito.when((Object)bundleContext.getService(this.ref1)).thenReturn((Object)this.observer1);
        Mockito.when((Object)bundleContext.getService(this.ref2)).thenReturn((Object)this.observer2);
        this.tracker.start(bundleContext);
    }

    @After
    public void tearDown() {
        this.tracker.stop();
    }

    @Test
    public void registerUnregister() {
        this.tracker.addingService(this.ref1);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer1), this.observers);
        this.tracker.addingService(this.ref2);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer1, (Object)this.observer2), this.observers);
        this.tracker.removedService(this.ref1, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer2), this.observers);
        this.tracker.removedService(this.ref2, null);
        Assert.assertTrue((boolean)this.observers.isEmpty());
    }

    @Test
    public void registerTwice() {
        this.tracker.addingService(this.ref1);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer1), this.observers);
        this.tracker.addingService(this.ref1);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer1), this.observers);
    }

    @Test
    public void unregisterWhenEmpty() {
        this.tracker.removedService(this.ref1, null);
        Assert.assertTrue((boolean)this.observers.isEmpty());
    }

    @Test
    public void unregisterTwice() {
        this.tracker.addingService(this.ref1);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.observer1), this.observers);
        this.tracker.removedService(this.ref1, null);
        Assert.assertTrue((boolean)this.observers.isEmpty());
        this.tracker.removedService(this.ref1, null);
        Assert.assertTrue((boolean)this.observers.isEmpty());
    }
}

