/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import org.apache.jackrabbit.oak.json.TypeCodes;
import org.junit.Assert;
import org.junit.Test;

public class TypeCodesTest {
    @Test
    public void testEncode() {
        Assert.assertEquals((Object)"str:foo", (Object)TypeCodes.encode((int)1, (String)"foo"));
        Assert.assertEquals((Object)":blobId:", (Object)TypeCodes.encode((int)2, (String)""));
        Assert.assertEquals((Object)"und:foo", (Object)TypeCodes.encode((int)0, (String)"foo"));
    }

    @Test
    public void testSplit() {
        Assert.assertEquals((long)3L, (long)TypeCodes.split((String)"str:foo"));
        Assert.assertEquals((long)3L, (long)TypeCodes.split((String)"str:"));
        Assert.assertEquals((long)-1L, (long)TypeCodes.split((String)"foo"));
        Assert.assertEquals((long)-1L, (long)TypeCodes.split((String)""));
    }

    @Test
    public void testDecodeType() {
        String strFoo = "str:foo";
        Assert.assertEquals((long)1L, (long)TypeCodes.decodeType((int)TypeCodes.split((String)strFoo), (String)strFoo));
        String str = "str:";
        Assert.assertEquals((long)1L, (long)TypeCodes.decodeType((int)TypeCodes.split((String)str), (String)str));
        String any = "any";
        Assert.assertEquals((long)0L, (long)TypeCodes.decodeType((int)TypeCodes.split((String)any), (String)any));
        String empty = "";
        Assert.assertEquals((long)0L, (long)TypeCodes.decodeType((int)TypeCodes.split((String)empty), (String)empty));
    }

    @Test
    public void testDecodeName() {
        String strFoo = "str:foo";
        Assert.assertEquals((Object)"foo", (Object)TypeCodes.decodeName((int)TypeCodes.split((String)strFoo), (String)strFoo));
        String str = "str:";
        Assert.assertEquals((Object)"", (Object)TypeCodes.decodeName((int)TypeCodes.split((String)str), (String)str));
        String any = "any";
        Assert.assertEquals((Object)"any", (Object)TypeCodes.decodeName((int)TypeCodes.split((String)any), (String)any));
        String empty = "";
        Assert.assertEquals((Object)"", (Object)TypeCodes.decodeName((int)TypeCodes.split((String)empty), (String)empty));
    }
}

