/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.junit.Assert;
import org.junit.Test;

public class AbstractBlobTest {
    private Random rnd = new Random();

    @Test
    public void blobComparisonBasedOnContentIdentity() throws Exception {
        byte[] data = this.bytes(100);
        TestBlob a = new TestBlob(data, "id1", false);
        TestBlob b = new TestBlob(data, "id1", false);
        Assert.assertTrue((boolean)AbstractBlob.equal((Blob)a, (Blob)b));
        TestBlob a2 = new TestBlob(data, "id1", true);
        TestBlob b2 = new TestBlob(data, "id2", true);
        Assert.assertTrue((String)"Blobs with different id but same content should match", (boolean)AbstractBlob.equal((Blob)a2, (Blob)b2));
    }

    @Test
    public void blobComparisonBasedOnLength() throws Exception {
        TestBlob a = new TestBlob(this.bytes(100), null, false);
        TestBlob b = new TestBlob(this.bytes(50), null, false);
        Assert.assertFalse((String)"Blob comparison should not fallback on content if lengths not same", (boolean)AbstractBlob.equal((Blob)a, (Blob)b));
    }

    private byte[] bytes(int size) {
        byte[] data = new byte[size];
        this.rnd.nextBytes(data);
        return data;
    }

    private static class TestBlob
    extends ArrayBasedBlob {
        private final String id;
        private final boolean allowAccessToContent;

        public TestBlob(byte[] value, String id, boolean allowAccessToContent) {
            super(value);
            this.id = id;
            this.allowAccessToContent = allowAccessToContent;
        }

        public String getContentIdentity() {
            return this.id;
        }

        @Nonnull
        public InputStream getNewStream() {
            Preconditions.checkState((boolean)this.allowAccessToContent, (Object)"Cannot access the stream");
            return super.getNewStream();
        }
    }
}

