/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.plugins.value.BinaryBasedBlob;
import org.junit.Assert;
import org.junit.Test;

public class BinaryBasedBlobTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getStream() throws RepositoryException, IOException {
        byte[] bytes = "just a test".getBytes();
        TestBinary binary = new TestBinary(bytes);
        BinaryBasedBlob blob = new BinaryBasedBlob((Binary)binary);
        Assert.assertEquals((long)bytes.length, (long)blob.length());
        InputStream expected = binary.getStream();
        InputStream actual = blob.getNewStream();
        try {
            int e = expected.read();
            while (e != -1) {
                Assert.assertEquals((long)e, (long)actual.read());
                e = expected.read();
            }
            Assert.assertEquals((long)-1L, (long)actual.read());
        }
        finally {
            expected.close();
            actual.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getStreamWithError() throws IOException {
        BinaryBasedBlob blob = new BinaryBasedBlob((Binary)new FailingBinary());
        Assert.assertEquals((long)-1L, (long)blob.length());
        try (InputStream ins = blob.getNewStream();){
            ins.read();
            Assert.fail();
        }
    }

    private static class FailingBinary
    implements Binary {
        private FailingBinary() {
        }

        public InputStream getStream() throws RepositoryException {
            throw new RepositoryException("no stream");
        }

        public int read(byte[] b, long position) throws IOException, RepositoryException {
            throw new RepositoryException("no stream");
        }

        public long getSize() throws RepositoryException {
            return -1L;
        }

        public void dispose() {
        }
    }

    private static class TestBinary
    implements Binary {
        private final byte[] data;

        public TestBinary(byte[] data) {
            this.data = data;
        }

        public InputStream getStream() throws RepositoryException {
            return new ByteArrayInputStream(this.data);
        }

        public int read(byte[] b, long position) throws IOException, RepositoryException {
            return this.getStream().read(b, (int)position, b.length);
        }

        public long getSize() throws RepositoryException {
            return this.data.length;
        }

        public void dispose() {
        }
    }
}

