/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.DefaultMoveValidator;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.state.MoveDetector;
import org.apache.jackrabbit.oak.spi.state.MoveValidator;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MoveDetectorTest {
    private NodeState root;

    @Before
    public void setup() {
        NodeBuilder rootBuilder = EmptyNodeState.EMPTY_NODE.builder();
        NodeBuilder test = rootBuilder.child("test");
        test.setProperty("a", (Object)1);
        test.setProperty("b", (Object)2);
        test.setProperty("c", (Object)3);
        test.child("x");
        test.child("y");
        test.child("z").child("zz");
        this.root = rootBuilder.getNodeState();
    }

    @Test
    public void simpleMove() throws CommitFailedException {
        NodeState moved1 = MoveDetectorTest.move(this.root.builder(), "/test/x", "/test/y/xx").getNodeState();
        MoveExpectation moveExpectation1 = new MoveExpectation((Map<String, String>)ImmutableMap.of((Object)"/test/x", (Object)"/test/y/xx"));
        MoveDetector moveDetector1 = new MoveDetector((MoveValidator)moveExpectation1);
        CommitFailedException exception1 = EditorDiff.process((Editor)moveDetector1, (NodeState)this.root, (NodeState)moved1);
        if (exception1 != null) {
            throw exception1;
        }
        moveExpectation1.assertAllFound();
        NodeState moved2 = MoveDetectorTest.move(moved1.builder(), "/test/y/xx", "/test/x").getNodeState();
        MoveExpectation moveExpectation2 = new MoveExpectation((Map<String, String>)ImmutableMap.of((Object)"/test/y/xx", (Object)"/test/x"));
        MoveDetector moveDetector2 = new MoveDetector((MoveValidator)moveExpectation2);
        CommitFailedException exception2 = EditorDiff.process((Editor)moveDetector2, (NodeState)moved1, (NodeState)moved2);
        if (exception2 != null) {
            throw exception2;
        }
        moveExpectation2.assertAllFound();
    }

    @Test
    public void moveMoved() throws CommitFailedException {
        NodeBuilder rootBuilder = this.root.builder();
        MoveDetectorTest.move(rootBuilder, "/test/x", "/test/y/xx");
        NodeState moved = MoveDetectorTest.move(rootBuilder, "/test/y/xx", "/test/z/xxx").getNodeState();
        MoveExpectation moveExpectation = new MoveExpectation((Map<String, String>)ImmutableMap.of((Object)"/test/x", (Object)"/test/z/xxx"));
        MoveDetector moveDetector = new MoveDetector((MoveValidator)moveExpectation);
        CommitFailedException exception = EditorDiff.process((Editor)moveDetector, (NodeState)this.root, (NodeState)moved);
        if (exception != null) {
            throw exception;
        }
        moveExpectation.assertAllFound();
    }

    @Test
    public void moveAddedNode() throws CommitFailedException {
        NodeBuilder rootBuilder = this.root.builder();
        rootBuilder.getChildNode("test").setChildNode("added");
        NodeState moved = MoveDetectorTest.move(rootBuilder, "/test/added", "/test/y/added").getNodeState();
        MoveExpectation moveExpectation = new MoveExpectation((Map<String, String>)ImmutableMap.of());
        MoveDetector moveDetector = new MoveDetector((MoveValidator)moveExpectation);
        CommitFailedException exception = EditorDiff.process((Editor)moveDetector, (NodeState)this.root, (NodeState)moved);
        if (exception != null) {
            throw exception;
        }
        moveExpectation.assertAllFound();
    }

    @Test
    public void moveFromMovedSubtree() throws CommitFailedException {
        NodeBuilder rootBuilder = this.root.builder();
        MoveDetectorTest.move(rootBuilder, "/test/z", "/test/y/z");
        NodeState moved = MoveDetectorTest.move(rootBuilder, "/test/y/z/zz", "/test/x/zz").getNodeState();
        MoveExpectation moveExpectation = new MoveExpectation((Map<String, String>)ImmutableMap.of((Object)"/test/z", (Object)"/test/y/z", (Object)"/test/z/zz", (Object)"/test/x/zz"));
        MoveDetector moveDetector = new MoveDetector((MoveValidator)moveExpectation);
        CommitFailedException exception = EditorDiff.process((Editor)moveDetector, (NodeState)this.root, (NodeState)moved);
        if (exception != null) {
            throw exception;
        }
        moveExpectation.assertAllFound();
    }

    @Test
    public void moveAddedFromMovedSubtree() throws CommitFailedException {
        NodeBuilder rootBuilder = this.root.builder();
        rootBuilder.getChildNode("test").getChildNode("z").setChildNode("added");
        MoveDetectorTest.move(rootBuilder, "/test/z", "/test/y/z");
        NodeState moved = MoveDetectorTest.move(rootBuilder, "/test/y/z/added", "/test/x/added").getNodeState();
        MoveExpectation moveExpectation = new MoveExpectation((Map<String, String>)ImmutableMap.of((Object)"/test/z", (Object)"/test/y/z"));
        MoveDetector moveDetector = new MoveDetector((MoveValidator)moveExpectation);
        CommitFailedException exception = EditorDiff.process((Editor)moveDetector, (NodeState)this.root, (NodeState)moved);
        if (exception != null) {
            throw exception;
        }
        moveExpectation.assertAllFound();
    }

    @Test
    public void moveForthAndBack() throws CommitFailedException {
        NodeBuilder rootBuilder = this.root.builder();
        MoveDetectorTest.move(rootBuilder, "/test/x", "/test/y/xx");
        NodeState moved = MoveDetectorTest.move(rootBuilder, "/test/y/xx", "/test/x").getNodeState();
        MoveExpectation moveExpectation = new MoveExpectation((Map<String, String>)ImmutableMap.of());
        MoveDetector moveDetector = new MoveDetector((MoveValidator)moveExpectation);
        CommitFailedException exception = EditorDiff.process((Editor)moveDetector, (NodeState)this.root, (NodeState)moved);
        if (exception != null) {
            throw exception;
        }
        moveExpectation.assertAllFound();
    }

    private static NodeBuilder move(NodeBuilder builder, String source, String dest) {
        NodeBuilder sourceBuilder = MoveDetectorTest.getBuilder(builder, source);
        NodeBuilder destParentBuilder = MoveDetectorTest.getBuilder(builder, PathUtils.getParentPath((String)dest));
        Assert.assertTrue((boolean)sourceBuilder.moveTo(destParentBuilder, PathUtils.getName((String)dest)));
        return builder;
    }

    private static NodeBuilder getBuilder(NodeBuilder builder, String path) {
        for (String name : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    private static class MoveExpectation
    extends DefaultMoveValidator {
        private final Map<String, String> moves;
        private final String path;

        private MoveExpectation(Map<String, String> moves, String path) {
            this.moves = moves;
            this.path = path;
        }

        public MoveExpectation(Map<String, String> moves) {
            this(Maps.newHashMap(moves), "/");
        }

        public void move(String name, String sourcePath, NodeState moved) throws CommitFailedException {
            String actualDestPath = PathUtils.concat((String)this.path, (String)name);
            String expectedDestPath = this.moves.remove(sourcePath);
            Assert.assertEquals((String)("Unexpected move. Expected: " + (expectedDestPath == null ? "None" : '>' + sourcePath + ':' + expectedDestPath) + " Found: >" + sourcePath + ':' + actualDestPath), (Object)expectedDestPath, (Object)actualDestPath);
        }

        public MoveValidator childNodeChanged(String name, NodeState before, NodeState after) {
            return new MoveExpectation(this.moves, PathUtils.concat((String)this.path, (String)name));
        }

        public void assertAllFound() {
            Assert.assertTrue((String)("Missing moves: " + this.moves), (boolean)this.moves.isEmpty());
        }
    }
}

