/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.Lists;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.util.ISO8601;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PropertyStatesTest {
    private final NamePathMapper namePathMapper = (NamePathMapper)Mockito.mock(NamePathMapper.class);
    private final PartialValueFactory valueFactory = new PartialValueFactory(this.namePathMapper);

    @Test
    public void emptyPropertyStateTest() {
        PropertyState s = EmptyPropertyState.emptyProperty((String)"test", (Type)Type.STRINGS);
        Assert.assertEquals((Object)"test", (Object)s.getName());
        Assert.assertFalse((boolean)((Iterable)s.getValue(Type.STRINGS)).iterator().hasNext());
        Assert.assertTrue((boolean)s.isArray());
        Assert.assertEquals((Object)Type.STRINGS, (Object)s.getType());
        Assert.assertEquals((long)0L, (long)s.count());
        try {
            s.getValue(Type.STRING, 0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            s.size();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            s.size(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            s.getValue(Type.STRING);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPropertyStateNotArrayTest() {
        EmptyPropertyState.emptyProperty((String)"test", (Type)Type.STRING);
    }

    @Test
    public void multiPropertyStateTest() {
        MultiStringPropertyState s = new MultiStringPropertyState("test", (Iterable)Lists.newArrayList((Object[])new String[]{"hello", "world"}));
        Assert.assertEquals((Object)Type.STRINGS, (Object)s.getType());
        Assert.assertEquals((Object)"test", (Object)s.getName());
        Assert.assertTrue((boolean)((Iterable)s.getValue(Type.STRINGS)).iterator().hasNext());
        Assert.assertEquals((long)2L, (long)s.count());
        Assert.assertEquals((long)"hello".length(), (long)s.size(0));
        Assert.assertEquals((long)"world".length(), (long)s.size(1));
        Assert.assertEquals((Object)"hello", (Object)s.getValue(Type.STRING, 0));
        Assert.assertEquals((Object)"world", (Object)s.getValue(Type.STRING, 1));
        try {
            s.getValue(Type.STRING);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            s.size();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void namePropertyFromNameValue() throws RepositoryException {
        PropertyState nameProperty = PropertyStates.createProperty((String)"name", (String)"oak-prefix:value", (int)7);
        Value nameValue = this.valueFactory.createValue(nameProperty);
        PropertyState namePropertyFromValue = PropertyStates.createProperty((String)"name", (Value)nameValue);
        Assert.assertEquals((Object)nameProperty, (Object)namePropertyFromValue);
    }

    @Test
    public void pathPropertyFromPathValue() throws RepositoryException {
        PropertyState pathProperty = PropertyStates.createProperty((String)"path", (String)"oak-prefix:a/oak-prefix:b", (int)8);
        Value nameValue = this.valueFactory.createValue(pathProperty);
        PropertyState namePropertyFromValue = PropertyStates.createProperty((String)"path", (Value)nameValue);
        Assert.assertEquals((Object)pathProperty, (Object)namePropertyFromValue);
    }

    @Test
    public void dateValueFromDateProperty() throws RepositoryException {
        String expected = ISO8601.format((Calendar)Calendar.getInstance());
        PropertyState dateProperty = PropertyStates.createProperty((String)"date", (Object)expected, (Type)Type.DATE);
        String actual = (String)dateProperty.getValue(Type.DATE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

