/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Arrays;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiLongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.junit.Assert;
import org.junit.Test;

public class PropertyBuilderTest {
    @Test
    public void testStringProperty() {
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.STRING);
        builder.setName("foo").setValue((Object)"bar");
        Assert.assertEquals((Object)StringPropertyState.stringProperty((String)"foo", (String)"bar"), (Object)builder.getPropertyState());
        builder.setArray();
        Assert.assertEquals((Object)MultiStringPropertyState.stringProperty((String)"foo", Arrays.asList("bar")), (Object)builder.getPropertyState());
    }

    @Test
    public void testLongProperty() {
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.LONG);
        builder.setName("foo").setValue((Object)42L);
        Assert.assertEquals((Object)LongPropertyState.createLongProperty((String)"foo", (long)42L), (Object)builder.getPropertyState());
        builder.setArray();
        Assert.assertEquals((Object)MultiLongPropertyState.createLongProperty((String)"foo", Arrays.asList(42L)), (Object)builder.getPropertyState());
    }

    @Test
    public void testStringsProperty() {
        PropertyBuilder builder = PropertyBuilder.array((Type)Type.STRING);
        builder.setName("foo").addValue((Object)"one").addValue((Object)"two");
        Assert.assertEquals((Object)MultiStringPropertyState.stringProperty((String)"foo", Arrays.asList("one", "two")), (Object)builder.getPropertyState());
        builder.setScalar();
        try {
            builder.getPropertyState();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder.removeValue((Object)"one");
        Assert.assertEquals((Object)StringPropertyState.stringProperty((String)"foo", (String)"two"), (Object)builder.getPropertyState());
    }

    @Test
    public void testDateProperty() {
        PropertyBuilder builder = PropertyBuilder.array((Type)Type.DATE);
        String date1 = "1970-01-01T00:00:00.000Z";
        String date2 = "1971-01-01T00:00:00.000Z";
        builder.setName("foo").addValue((Object)date1).addValue((Object)date2);
        Assert.assertEquals((Object)MultiGenericPropertyState.dateProperty((String)"foo", Arrays.asList(date1, date2)), (Object)builder.getPropertyState());
        builder.setScalar();
        try {
            builder.getPropertyState();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        builder.removeValue((Object)date1);
        Assert.assertEquals((Object)GenericPropertyState.dateProperty((String)"foo", (String)date2), (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignFromLong() {
        PropertyState source = LongPropertyState.createLongProperty((String)"foo", (long)42L);
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.STRING);
        builder.assignFrom(source);
        Assert.assertEquals((Object)StringPropertyState.stringProperty((String)"foo", (String)"42"), (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignFromString() {
        PropertyState source = StringPropertyState.stringProperty((String)"foo", (String)"42");
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.LONG);
        builder.assignFrom(source);
        Assert.assertEquals((Object)LongPropertyState.createLongProperty((String)"foo", (long)42L), (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignFromDate() {
        String date = "1970-01-01T00:00:00.000Z";
        PropertyState source = GenericPropertyState.dateProperty((String)"foo", (String)date);
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.DATE);
        builder.assignFrom(source);
        Assert.assertEquals((Object)source, (Object)builder.getPropertyState());
    }

    @Test(expected=NumberFormatException.class)
    public void testAssignFromStringNumberFormatException() {
        PropertyState source = StringPropertyState.stringProperty((String)"foo", (String)"bar");
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.LONG);
        builder.assignFrom(source);
    }

    @Test
    public void testAssignFromLongs() {
        PropertyState source = MultiLongPropertyState.createLongProperty((String)"foo", Arrays.asList(1L, 2L, 3L));
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.STRING);
        builder.assignFrom(source);
        Assert.assertEquals((Object)MultiStringPropertyState.stringProperty((String)"foo", Arrays.asList("1", "2", "3")), (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignFromStrings() {
        PropertyState source = MultiStringPropertyState.stringProperty((String)"foo", Arrays.asList("1", "2", "3"));
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.LONG);
        builder.assignFrom(source);
        Assert.assertEquals((Object)MultiLongPropertyState.createLongProperty((String)"foo", Arrays.asList(1L, 2L, 3L)), (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignFromDates() {
        String date1 = "1970-01-01T00:00:00.000Z";
        String date2 = "1971-01-01T00:00:00.000Z";
        PropertyState source = MultiGenericPropertyState.dateProperty((String)"foo", Arrays.asList(date1, date2));
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.DATE);
        builder.assignFrom(source);
        Assert.assertEquals((Object)source, (Object)builder.getPropertyState());
    }

    @Test
    public void testAssignInvariant() {
        PropertyState source = MultiStringPropertyState.stringProperty((String)"source", Arrays.asList("1", "2", "3"));
        PropertyBuilder builder = PropertyBuilder.scalar((Type)Type.STRING);
        builder.assignFrom(source);
        Assert.assertEquals((Object)source, (Object)builder.getPropertyState());
    }
}

