/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.Nullable;

public class VisibleEditor
implements Editor {
    private final Editor editor;

    @Nullable
    public static Editor wrap(@Nullable Editor editor) {
        if (editor != null && !(editor instanceof VisibleEditor)) {
            return new VisibleEditor(editor);
        }
        return editor;
    }

    public VisibleEditor(Editor editor) {
        this.editor = (Editor)Preconditions.checkNotNull((Object)editor);
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.enter(before, after);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.leave(before, after);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(after.getName())) {
            this.editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(after.getName())) {
            this.editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(before.getName())) {
            this.editor.propertyDeleted(before);
        }
    }

    @Override
    @Nullable
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(name)) {
            return VisibleEditor.wrap(this.editor.childNodeAdded(name, after));
        }
        return null;
    }

    @Override
    @Nullable
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(name)) {
            return VisibleEditor.wrap(this.editor.childNodeChanged(name, before, after));
        }
        return null;
    }

    @Override
    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (!NodeStateUtils.isHidden(name)) {
            return VisibleEditor.wrap(this.editor.childNodeDeleted(name, before));
        }
        return null;
    }
}

