/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public class SubtreeEditor
extends DefaultEditor {
    private final Editor editor;
    private final String[] path;
    private final int depth;

    private SubtreeEditor(Editor editor, String[] path, int depth) {
        this.editor = (Editor)Preconditions.checkNotNull((Object)editor);
        this.path = (String[])Preconditions.checkNotNull((Object)path);
        Preconditions.checkElementIndex((int)depth, (int)path.length);
        this.depth = depth;
    }

    public SubtreeEditor(Editor editor, String ... path) {
        this(editor, path, 0);
    }

    private Editor descend(String name) {
        if (!name.equals(this.path[this.depth])) {
            return null;
        }
        if (this.depth + 1 < this.path.length) {
            return new SubtreeEditor(this.editor, this.path, this.depth + 1);
        }
        return this.editor;
    }

    @Override
    @Nullable
    public Editor childNodeAdded(String name, NodeState after) {
        return this.descend(name);
    }

    @Override
    @Nullable
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return this.descend(name);
    }

    @Override
    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) {
        return this.descend(name);
    }
}

