/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.Base64BlobSerializer;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonDeserializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.junit.Assert;
import org.junit.Test;

public class JsonDeserializerTest {
    private Base64BlobSerializer blobHandler = new Base64BlobSerializer();
    private Random rnd = new Random();

    @Test
    public void basicStuff() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.child("a").setProperty("foo", (Object)"bar");
        builder.child("b").setProperty("foo", (Object)1);
        this.assertDeserialization(builder);
    }

    @Test
    public void variousPropertyTypes() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.child("a").setProperty("foo", (Object)10);
        builder.child("a").setProperty("foo2", (Object)"bar");
        builder.child("a").setProperty("foo3", (Object)true);
        builder.child("a").setProperty("foo4", (Object)false);
        builder.child("a").setProperty("foo5", (Object)1.1);
        builder.child("a").setProperty("foo6", (Object)"nt:base", Type.NAME);
        builder.child("a").child("b").setProperty("foo", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L}), Type.LONGS);
        builder.child("a").child("b").setProperty("foo2", (Object)Lists.newArrayList((Object[])new String[]{"x", "y", "z"}), Type.STRINGS);
        builder.child("a").child("b").setProperty("foo3", (Object)Lists.newArrayList((Object[])new Boolean[]{true, false}), Type.BOOLEANS);
        builder.child("a").child("b").setProperty("foo4", (Object)Lists.newArrayList((Object[])new Double[]{1.1, 1.2}), Type.DOUBLES);
        builder.child("a").child(":c").setProperty("foo", (Object)"bar");
        this.assertDeserialization(builder);
    }

    @Test
    public void emptyProperty() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.child("a").setProperty("foo", Collections.emptyList(), Type.NAMES);
        this.assertDeserialization(builder);
    }

    @Test
    public void binaryProperty() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.child("a").setProperty("foo", (Object)this.createBlob(100));
        builder.child("b").setProperty("foo", (Object)Lists.newArrayList((Object[])new Blob[]{this.createBlob(200), this.createBlob(300)}), Type.BINARIES);
        this.assertDeserialization(builder);
    }

    @Test
    public void primaryType() throws Exception {
        String json = "{\"jcr:primaryType\":\"oak:Unstructured\"}";
        NodeState nodeState2 = this.deserialize(json);
        Assert.assertEquals((Object)Type.NAME, (Object)nodeState2.getProperty("jcr:primaryType").getType());
    }

    @Test
    public void stringPropertyWithNamespace() throws Exception {
        String json = "{\"name\":\"jcr:content/metadata\"}";
        NodeState nodeState = this.deserialize(json);
        PropertyState name = nodeState.getProperty("name");
        Assert.assertEquals((Object)"jcr:content/metadata", (Object)name.getValue(Type.STRING));
        Assert.assertEquals((Object)Type.STRING, (Object)name.getType());
    }

    @Test
    public void stringArrayPropertyWithNamespace() throws Exception {
        String json = "{\"name\": [\"jcr:content/metadata\"] }";
        NodeState nodeState = this.deserialize(json);
        PropertyState name = nodeState.getProperty("name");
        Assert.assertEquals((Object)"jcr:content/metadata", (Object)name.getValue(Type.STRING, 0));
        Assert.assertEquals((Object)Type.STRINGS, (Object)name.getType());
    }

    @Test
    public void mixins() throws Exception {
        String json = "{\"jcr:mixinTypes\": [\"oak:Unstructured\", \"mixin:title\"]}";
        NodeState nodeState = this.deserialize(json);
        Assert.assertEquals((Object)Type.NAMES, (Object)nodeState.getProperty("jcr:mixinTypes").getType());
        Assert.assertEquals(Arrays.asList("oak:Unstructured", "mixin:title"), (Object)nodeState.getProperty("jcr:mixinTypes").getValue(Type.NAMES));
    }

    @Test
    public void childOrder() throws Exception {
        String json = "{\"jcr:primaryType\":\"nam:nt:unstructured\",\"a\":{},\"c\":{},\"b\":{}}";
        NodeState nodeState = this.deserialize(json);
        PropertyState childOrder = nodeState.getProperty(":childOrder");
        Assert.assertNotNull((Object)childOrder);
        Assert.assertEquals(Arrays.asList("a", "c", "b"), (Object)childOrder.getValue(Type.NAMES));
    }

    @Test
    public void otherArrayTypes() throws Exception {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setProperty("foo1", Arrays.asList("/content", "/libs"), Type.PATHS);
        builder.setProperty("foo2", Arrays.asList(1.2, 1.4), Type.DOUBLES);
        builder.setProperty("foo3", Arrays.asList(new BigDecimal("3.14159"), new BigDecimal("42.737")), Type.DECIMALS);
        this.assertDeserialization(builder);
    }

    private Blob createBlob(int length) {
        return new ArrayBasedBlob(this.randomBytes(length));
    }

    private byte[] randomBytes(int size) {
        byte[] data = new byte[size];
        this.rnd.nextBytes(data);
        return data;
    }

    private void assertDeserialization(NodeBuilder builder) {
        NodeState nodeState = builder.getNodeState();
        String json = this.serialize(nodeState);
        NodeState nodeState2 = this.deserialize(json);
        Assert.assertTrue((boolean)EqualsDiff.equals((NodeState)nodeState, (NodeState)nodeState2));
    }

    private NodeState deserialize(String json) {
        JsonDeserializer deserializer = new JsonDeserializer((BlobDeserializer)this.blobHandler);
        return deserializer.deserialize(json);
    }

    private String serialize(NodeState nodeState) {
        JsopBuilder json = new JsopBuilder();
        new JsonSerializer((JsopWriter)json, (BlobSerializer)this.blobHandler).serialize(nodeState);
        return json.toString();
    }
}

