/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.filter;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.junit.Assert;
import org.junit.Test;

public class PathFilterTest {
    @Test
    public void exclude() throws Exception {
        PathFilter p = new PathFilter((Iterable)ImmutableList.of((Object)"/"), (Iterable)ImmutableList.of((Object)"/etc"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/a"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow"));
    }

    @Test
    public void include() throws Exception {
        PathFilter p = new PathFilter((Iterable)ImmutableList.of((Object)"/content", (Object)"/etc"), (Iterable)ImmutableList.of((Object)"/etc/workflow/instance"));
        Assert.assertEquals((Object)PathFilter.Result.TRAVERSE, (Object)p.filter("/"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/var"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/content"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/content/example"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc/workflow"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow/instance"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow/instance/1"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/x"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/e"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etcx"));
    }

    @Test
    public void emptyConfig() throws Exception {
        NodeBuilder root = EmptyNodeState.EMPTY_NODE.builder();
        PathFilter p = PathFilter.from((NodeBuilder)root);
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/a"));
    }

    @Test
    public void config() throws Exception {
        NodeBuilder root = EmptyNodeState.EMPTY_NODE.builder();
        root.setProperty(PropertyStates.createProperty((String)"includedPaths", (Object)ImmutableList.of((Object)"/etc"), (Type)Type.STRINGS));
        root.setProperty(PropertyStates.createProperty((String)"excludedPaths", (Object)ImmutableList.of((Object)"/etc/workflow"), (Type)Type.STRINGS));
        PathFilter p = PathFilter.from((NodeBuilder)root);
        Assert.assertEquals((Object)PathFilter.Result.TRAVERSE, (Object)p.filter("/"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc/a"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow/1"));
    }

    @Test
    public void configOnlyExclude() throws Exception {
        NodeBuilder root = EmptyNodeState.EMPTY_NODE.builder();
        root.setProperty(PropertyStates.createProperty((String)"excludedPaths", (Object)ImmutableList.of((Object)"/etc/workflow"), (Type)Type.STRINGS));
        PathFilter p = PathFilter.from((NodeBuilder)root);
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc"));
        Assert.assertEquals((Object)PathFilter.Result.INCLUDE, (Object)p.filter("/etc/a"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow"));
        Assert.assertEquals((Object)PathFilter.Result.EXCLUDE, (Object)p.filter("/etc/workflow/1"));
    }

    @Test
    public void invalid() throws Exception {
        try {
            new PathFilter(Collections.emptyList(), (Iterable)ImmutableList.of((Object)"/etc"));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new PathFilter((Iterable)ImmutableList.of((Object)"/etc/workflow"), (Iterable)ImmutableList.of((Object)"/etc"));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new PathFilter(Collections.emptyList(), Collections.emptyList());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

