/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.util.ISO8601;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PropertyStatesTest {
    private final NamePathMapper namePathMapper = (NamePathMapper)Mockito.mock(NamePathMapper.class);
    private final PartialValueFactory valueFactory = new PartialValueFactory(this.namePathMapper);

    @Test
    public void namePropertyFromNameValue() throws RepositoryException {
        PropertyState nameProperty = PropertyStates.createProperty((String)"name", (String)"oak-prefix:value", (int)7);
        Value nameValue = this.valueFactory.createValue(nameProperty);
        PropertyState namePropertyFromValue = PropertyStates.createProperty((String)"name", (Value)nameValue);
        Assert.assertEquals((Object)nameProperty, (Object)namePropertyFromValue);
    }

    @Test
    public void pathPropertyFromPathValue() throws RepositoryException {
        PropertyState pathProperty = PropertyStates.createProperty((String)"path", (String)"oak-prefix:a/oak-prefix:b", (int)8);
        Value nameValue = this.valueFactory.createValue(pathProperty);
        PropertyState namePropertyFromValue = PropertyStates.createProperty((String)"path", (Value)nameValue);
        Assert.assertEquals((Object)pathProperty, (Object)namePropertyFromValue);
    }

    @Test
    public void dateValueFromDateProperty() throws RepositoryException {
        String expected = ISO8601.format((Calendar)Calendar.getInstance());
        PropertyState dateProperty = PropertyStates.createProperty((String)"date", (Object)expected, (Type)Type.DATE);
        String actual = (String)dateProperty.getValue(Type.DATE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

