/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.plugins.index.solr.SolrBaseTest;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.junit.Assert;
import org.junit.Test;

public class SolrIndexEditorIT
extends SolrBaseTest {
    @Test
    public void testAddSomeNodes() throws Exception {
        Root r = this.createRoot();
        r.getTree("/").addChild("a").addChild("b").addChild("doc1").setProperty("text", (Object)"hit that hot hat tattoo");
        r.getTree("/").getChild("a").addChild("c").addChild("doc2").setProperty("text", (Object)"it hits hot hats");
        r.getTree("/").getChild("a").getChild("b").addChild("doc3").setProperty("text", (Object)"tattoos hate hot hits");
        r.getTree("/").getChild("a").getChild("b").addChild("doc4").setProperty("text", (Object)"hats tattoos hit hot");
        r.commit();
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        QueryResponse queryResponse = this.server.query((SolrParams)query);
        Assert.assertTrue((String)"no documents were indexed", (queryResponse.getResults().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNode() throws Exception {
        Root r = this.createRoot();
        r.getTree("/").addChild("testRemoveNode").setProperty("foo", (Object)"bar");
        r.commit();
        SolrQuery query = new SolrQuery();
        query.setQuery("path_exact:\\/testRemoveNode");
        Assert.assertTrue((String)"item with id:testRemoveNode was not found in the index", (this.server.query((SolrParams)query).getResults().size() > 0 ? 1 : 0) != 0);
        r.getTree("/").getChild("testRemoveNode").remove();
        r.commit();
        Assert.assertTrue((String)"item with id:testRemoveNode was found in the index", (this.server.query((SolrParams)query).getResults().size() == 0 ? 1 : 0) != 0);
    }
}

