/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TestUtils
implements SolrServerProvider,
OakSolrConfigurationProvider {
    static final String SOLR_HOME_PATH = "/solr";
    private final SolrClient solrServer = TestUtils.createSolrServer();
    private final OakSolrConfiguration configuration = TestUtils.getTestConfiguration();

    public static SolrClient createSolrServer() {
        try {
            File file = new File(TestUtils.class.getResource(SOLR_HOME_PATH).toURI());
            EmbeddedSolrServerConfiguration configuration = new EmbeddedSolrServerConfiguration(file.getAbsolutePath(), "oak");
            EmbeddedSolrServerProvider provider = new EmbeddedSolrServerProvider(configuration);
            return provider.getSolrServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void cleanDataDir() {
        String path = TestUtils.class.getResource("/solr/oak/data").getFile();
        File file = new File(path);
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    public static OakSolrConfiguration getTestConfiguration() {
        return new DefaultSolrConfiguration(){

            @NotNull
            public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                return OakSolrConfiguration.CommitPolicy.HARD;
            }

            public boolean useForPropertyRestrictions() {
                return true;
            }

            public boolean useForPrimaryTypes() {
                return true;
            }

            public boolean useForPathRestrictions() {
                return true;
            }
        };
    }

    @Nullable
    public SolrClient getSolrServer() {
        return this.solrServer;
    }

    @Nullable
    public SolrClient getIndexingSolrServer() throws Exception {
        return this.solrServer;
    }

    @Nullable
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.solrServer;
    }

    @NotNull
    public OakSolrConfiguration getConfiguration() {
        return this.configuration;
    }

    public void close() throws IOException {
    }
}

