/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
public class RemoteSolrServerProvider
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(RemoteSolrServerProvider.class);
    private final RemoteSolrServerConfiguration remoteSolrServerConfiguration;

    public RemoteSolrServerProvider(RemoteSolrServerConfiguration remoteSolrServerConfiguration) {
        this.remoteSolrServerConfiguration = remoteSolrServerConfiguration;
    }

    @Override
    @Nullable
    public SolrClient getSolrServer() throws Exception {
        SolrClient solrServer = null;
        if (this.remoteSolrServerConfiguration.getSolrZkHost() != null && this.remoteSolrServerConfiguration.getSolrZkHost().length() > 0) {
            try {
                solrServer = this.initializeWithCloudSolrServer();
            }
            catch (Exception e) {
                this.log.warn("unable to initialize SolrCloud client for {}", (Object)this.remoteSolrServerConfiguration.getSolrZkHost(), (Object)e);
            }
        }
        if (solrServer == null && this.remoteSolrServerConfiguration.getSolrHttpUrls() != null && this.remoteSolrServerConfiguration.getSolrHttpUrls().length == 1 && this.remoteSolrServerConfiguration.getSolrHttpUrls()[0] != null && this.remoteSolrServerConfiguration.getSolrHttpUrls()[0].length() > 0) {
            try {
                solrServer = this.initializeWithExistingHttpServer();
            }
            catch (Exception e1) {
                this.log.warn("unable to initialize Solr HTTP client for {}", (Object)this.remoteSolrServerConfiguration.getSolrHttpUrls(), (Object)e1);
            }
        }
        if (solrServer == null) {
            throw new IOException("could not connect to any remote Solr server");
        }
        return solrServer;
    }

    @Override
    @Nullable
    public SolrClient getIndexingSolrServer() throws Exception {
        SolrClient server = this.getSolrServer();
        if (server instanceof HttpSolrClient) {
            String url = ((HttpSolrClient)server).getBaseURL();
            ConcurrentUpdateSolrClient s1 = new ConcurrentUpdateSolrClient.Builder(url).withQueueSize(1000).withThreadCount(Runtime.getRuntime().availableProcessors()).build();
            s1.setConnectionTimeout(this.remoteSolrServerConfiguration.getConnectionTimeout());
            s1.setSoTimeout(this.remoteSolrServerConfiguration.getSocketTimeout());
            server = s1;
        }
        return server;
    }

    @Override
    @Nullable
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private SolrClient initializeWithExistingHttpServer() throws IOException, SolrServerException {
        HttpSolrClient httpSolrServer = new HttpSolrClient.Builder(this.remoteSolrServerConfiguration.getSolrHttpUrls()[0]).build();
        httpSolrServer.setConnectionTimeout(this.remoteSolrServerConfiguration.getConnectionTimeout());
        httpSolrServer.setSoTimeout(this.remoteSolrServerConfiguration.getSocketTimeout());
        SolrPingResponse ping = httpSolrServer.ping();
        if (ping != null && 0 == ping.getStatus()) {
            return httpSolrServer;
        }
        httpSolrServer.close();
        throw new IOException("the found HTTP Solr server is not alive");
    }

    private SolrClient initializeWithCloudSolrServer() throws IOException {
        CloudSolrClient cloudSolrServer = new CloudSolrClient.Builder().withZkHost(Arrays.asList(this.remoteSolrServerConfiguration.getSolrZkHost().split(","))).build();
        cloudSolrServer.setZkConnectTimeout(this.remoteSolrServerConfiguration.getConnectionTimeout());
        cloudSolrServer.setSoTimeout(this.remoteSolrServerConfiguration.getSocketTimeout());
        cloudSolrServer.setIdField("path_exact");
        if (this.connectToZK(cloudSolrServer)) {
            block10: {
                this.log.debug("CloudSolrServer connected");
                cloudSolrServer.setDefaultCollection("collection1");
                try {
                    this.createCollectionIfNeeded(cloudSolrServer);
                }
                catch (Throwable t) {
                    if (!this.log.isWarnEnabled()) break block10;
                    this.log.warn("could not create the collection on {}", (Object)this.remoteSolrServerConfiguration.getSolrZkHost(), (Object)t);
                }
            }
            cloudSolrServer.setDefaultCollection(this.remoteSolrServerConfiguration.getSolrCollection());
            this.log.debug("waiting for CloudSolrServer to come alive");
            for (int i = 0; i < 3; ++i) {
                try {
                    SolrPingResponse ping = cloudSolrServer.ping();
                    if (ping != null && 0 == ping.getStatus()) {
                        return cloudSolrServer;
                    }
                    cloudSolrServer.close();
                    throw new IOException("the found SolrCloud server is not alive");
                }
                catch (Exception e) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("server is not alive yet, wait a bit", (Throwable)e);
                        }
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            cloudSolrServer.close();
            throw new IOException("the found SolrCloud server is not alive");
        }
        cloudSolrServer.close();
        throw new IOException("could not connect to Zookeeper hosted at " + this.remoteSolrServerConfiguration.getSolrZkHost());
    }

    private boolean connectToZK(CloudSolrClient cloudSolrServer) {
        this.log.debug("connecting to {}", (Object)cloudSolrServer.getZkHost());
        boolean connected = false;
        for (int i = 0; i < 3; ++i) {
            try {
                cloudSolrServer.connect();
                connected = true;
                break;
            }
            catch (Exception e) {
                this.log.warn("could not connect to ZK", (Throwable)e);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return connected;
    }

    private void createCollectionIfNeeded(CloudSolrClient cloudSolrServer) throws SolrServerException {
        String solrCollection = this.remoteSolrServerConfiguration.getSolrCollection();
        ZkStateReader zkStateReader = cloudSolrServer.getZkStateReader();
        SolrZkClient zkClient = zkStateReader.getZkClient();
        this.log.debug("creating {} collection if needed", (Object)solrCollection);
        try {
            if (zkClient.isConnected() && !zkClient.exists("/configs/" + solrCollection, true).booleanValue()) {
                Path dir;
                String solrConfDir = this.remoteSolrServerConfiguration.getSolrConfDir();
                if (solrConfDir != null && solrConfDir.length() > 0) {
                    this.log.info("uploading config from {}", (Object)solrConfDir);
                    dir = Paths.get(solrConfDir, new String[0]);
                } else {
                    Path tempDirectory = Files.createTempDirectory("oak-solr-conf", new FileAttribute[0]);
                    this.copy("schema", tempDirectory);
                    this.copy("solrconfig", tempDirectory);
                    this.log.info("uploading config from {}", (Object)tempDirectory);
                    dir = tempDirectory;
                }
                this.log.debug("uploading config from {}", (Object)dir);
                zkClient.upConfig(dir, solrCollection);
                this.log.debug("creating collection {}", (Object)solrCollection);
                CollectionAdminRequest.Create req = CollectionAdminRequest.Create.createCollection((String)solrCollection, (int)this.remoteSolrServerConfiguration.getSolrShardsNo(), (int)this.remoteSolrServerConfiguration.getSolrReplicationFactor());
                CollectionAdminResponse response = (CollectionAdminResponse)req.process((SolrClient)cloudSolrServer);
                this.log.info("collection creation response {}", (Object)response);
                cloudSolrServer.request((SolrRequest)req);
            }
        }
        catch (Exception e) {
            this.log.warn("could not create collection {}", (Object)solrCollection);
            throw new SolrServerException((Throwable)e);
        }
    }

    private void copy(String name, Path tempDirectory) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/solr/oak/conf/" + name + ".xml");
        File dir = tempDirectory.toFile();
        File newFile = new File(dir, name + ".xml");
        assert (newFile.createNewFile());
        FileOutputStream outputStream = new FileOutputStream(newFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }

    @Override
    public void close() throws IOException {
    }
}

