/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.plugins.index.search.util.LMSEstimator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.OakSolrNodeStateConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.FilterQueryParser;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
public class SolrQueryIndex
implements QueryIndex.FulltextQueryIndex,
QueryIndex.AdvanceFulltextQueryIndex {
    public static final String TYPE = "solr";
    static final String NATIVE_SOLR_QUERY = "native*solr";
    static final String NATIVE_LUCENE_QUERY = "native*lucene";
    private static double MIN_COST = 2.3;
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    private final QueryIndex.NodeAggregator aggregator;
    private final OakSolrConfigurationProvider fallbackOakSolrConfigurationProvider;
    private final SolrServerProvider fallbackSolrServerProvider;
    private static final Map<String, LMSEstimator> estimators = new WeakHashMap<String, LMSEstimator>();

    public SolrQueryIndex(QueryIndex.NodeAggregator aggregator, OakSolrConfigurationProvider oakSolrConfigurationProvider, SolrServerProvider solrServerProvider) {
        this.aggregator = aggregator;
        this.fallbackOakSolrConfigurationProvider = oakSolrConfigurationProvider;
        this.fallbackSolrServerProvider = solrServerProvider;
    }

    public double getMinimumCost() {
        return MIN_COST;
    }

    public String getIndexName() {
        return TYPE;
    }

    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    int getMatchingFilterRestrictions(Filter filter, OakSolrConfiguration configuration) {
        int match = 0;
        if (filter.getFullTextConstraint() != null || filter.getFulltextConditions() != null && filter.getFulltextConditions().size() > 0) {
            ++match;
        }
        if (filter.getPropertyRestrictions() != null && filter.getPropertyRestrictions().size() > 0 && (filter.getPropertyRestriction(NATIVE_SOLR_QUERY) != null || filter.getPropertyRestriction(NATIVE_LUCENE_QUERY) != null || configuration.useForPropertyRestrictions()) && !SolrQueryIndex.hasIgnoredProperties(filter.getPropertyRestrictions(), configuration)) {
            ++match;
        }
        if (filter.getPathRestriction() != null && !Filter.PathRestriction.NO_RESTRICTION.equals((Object)filter.getPathRestriction()) && configuration.useForPathRestrictions() && match > 0) {
            ++match;
        }
        if (filter.getPrimaryTypes().size() > 0 && configuration.useForPrimaryTypes() && match > 0) {
            ++match;
        }
        this.log.debug("{}\u00a0matched restrictions for filter {} and configuration {}", new Object[]{match, filter, configuration});
        return match;
    }

    private static boolean hasIgnoredProperties(Collection<Filter.PropertyRestriction> propertyRestrictions, OakSolrConfiguration configuration) {
        for (Filter.PropertyRestriction pr : propertyRestrictions) {
            if (!SolrQueryIndex.isIgnoredProperty(pr, configuration)) continue;
            return true;
        }
        return false;
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth((String)p) > 1) {
                        String parent = PathUtils.getParentPath((String)p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    public Cursor query(QueryIndex.IndexPlan plan, NodeState root) {
        SolrRowCursor cursor;
        try {
            Filter filter = plan.getFilter();
            Set relPaths = filter.getFullTextConstraint() != null ? SolrQueryIndex.getRelativePaths(filter.getFullTextConstraint()) : Collections.emptySet();
            String parent = relPaths.size() == 0 ? "" : (String)relPaths.iterator().next();
            int parentDepth = PathUtils.getDepth((String)parent);
            String path = plan.getPlanName();
            OakSolrConfiguration configuration = this.getConfiguration(path, root);
            SolrClient solrServer = this.getServer(path, root);
            LMSEstimator estimator = this.getEstimator(path);
            AbstractIterator<SolrResultRow> iterator = this.getIterator(filter, plan, parent, parentDepth, configuration, solrServer, estimator);
            cursor = new SolrRowCursor((Iterator<SolrResultRow>)iterator, plan, filter.getQueryLimits(), estimator, solrServer, configuration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    private synchronized LMSEstimator getEstimator(String path) {
        estimators.putIfAbsent(path, new LMSEstimator());
        return estimators.get(path);
    }

    private SolrClient getServer(String path, NodeState root) {
        NodeState node = root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        try {
            if (SolrIndexInitializer.isSolrIndexNode(node)) {
                if (node.hasChildNode("server")) {
                    NodeStateSolrServerConfigurationProvider solrServerConfigurationProvider = new NodeStateSolrServerConfigurationProvider(node.getChildNode("server"));
                    return new OakSolrServer(solrServerConfigurationProvider);
                }
                return this.fallbackSolrServerProvider.getSearchingSolrServer();
            }
            if (node.exists()) {
                this.log.warn("Cannot open Solr Index at path {} as the index is not of type 'solr'", (Object)path);
            }
        }
        catch (Exception e) {
            this.log.error("Could not access the Solr index at " + path, (Throwable)e);
        }
        return null;
    }

    private AbstractIterator<SolrResultRow> getIterator(final Filter filter, final QueryIndex.IndexPlan plan, final String parent, final int parentDepth, final OakSolrConfiguration configuration, final SolrClient solrServer, final LMSEstimator estimator) {
        return new AbstractIterator<SolrResultRow>(){
            public Collection<FacetField> facetFields = new LinkedList<FacetField>();
            private final Set<String> seenPaths = new HashSet<String>();
            private final Deque<SolrResultRow> queue = new ArrayDeque<SolrResultRow>();
            private int offset = 0;
            private boolean noDocs = false;
            private long numFound = 0L;

            protected SolrResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (SolrResultRow)this.endOfData();
            }

            private SolrResultRow convertToRow(SolrDocument doc) {
                String path = String.valueOf(doc.getFieldValue(configuration.getPathField()));
                if ("".equals(path)) {
                    path = "/";
                }
                if (!parent.isEmpty()) {
                    if (this.seenPaths.contains(path = PathUtils.getAncestorPath((String)path, (int)parentDepth))) {
                        return null;
                    }
                    this.seenPaths.add(path);
                }
                float score = 0.0f;
                Object scoreObj = doc.get((Object)"score");
                if (scoreObj != null) {
                    score = ((Float)scoreObj).floatValue();
                }
                return new SolrResultRow(path, score, doc, this.facetFields);
            }

            private boolean loadDocs() {
                block20: {
                    if (this.noDocs) {
                        return false;
                    }
                    try {
                        Set<Map.Entry<String, Object>> suggestEntries;
                        NamedList response;
                        Map suggest;
                        SpellCheckResponse spellCheckResponse;
                        List returnedFieldFacet;
                        SolrDocumentList docs;
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("converting filter {}", (Object)filter);
                        }
                        SolrQuery query = FilterQueryParser.getQuery(filter, plan, configuration);
                        if (this.numFound > 0L) {
                            long newOffset;
                            long rows = configuration.getRows();
                            long maxQueries = this.numFound / 2L;
                            if (maxQueries > (long)configuration.getRows()) {
                                rows = maxQueries;
                                query.setParam("rows", new String[]{String.valueOf(rows)});
                            }
                            if ((newOffset = (long)configuration.getRows() + (long)this.offset * rows) >= this.numFound) {
                                return false;
                            }
                            query.setParam("start", new String[]{String.valueOf(newOffset)});
                            ++this.offset;
                        }
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("sending query {}", (Object)query);
                        }
                        QueryResponse queryResponse = solrServer.query((SolrParams)query);
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("getting response {}", (Object)queryResponse.getHeader());
                        }
                        if ((docs = queryResponse.getResults()) != null) {
                            this.numFound = docs.getNumFound();
                            estimator.update(filter, this.numFound);
                            Map highlighting = queryResponse.getHighlighting();
                            for (SolrDocument doc : docs) {
                                SolrResultRow row;
                                Object pathObject;
                                if (highlighting != null && (pathObject = doc.getFieldValue(configuration.getPathField())) != null && highlighting.get(String.valueOf(pathObject)) != null) {
                                    Map value = (Map)highlighting.get(String.valueOf(pathObject));
                                    for (Map.Entry entry : value.entrySet()) {
                                        for (String v : (List)entry.getValue()) {
                                            doc.addField("rep:excerpt", (Object)v);
                                        }
                                    }
                                }
                                if ((row = this.convertToRow(doc)) == null) continue;
                                this.queue.add(row);
                            }
                        }
                        if ((returnedFieldFacet = queryResponse.getFacetFields()) != null) {
                            this.facetFields.addAll(returnedFieldFacet);
                        }
                        if (!this.facetFields.isEmpty() && docs != null) {
                            for (SolrDocument doc : docs) {
                                String path = String.valueOf(doc.getFieldValue(configuration.getPathField()));
                                for (FacetField ff : this.facetFields) {
                                    if (filter.isAccessible(path + "/" + ff.getName())) continue;
                                    SolrQueryIndex.this.filterFacet(doc, ff);
                                }
                            }
                        }
                        if ((spellCheckResponse = queryResponse.getSpellCheckResponse()) != null && spellCheckResponse.getSuggestions() != null && spellCheckResponse.getSuggestions().size() > 0) {
                            SolrQueryIndex.this.putSpellChecks(spellCheckResponse, this.queue, filter, configuration, solrServer);
                            this.noDocs = true;
                        }
                        if ((suggest = (Map)(response = queryResponse.getResponse()).get("suggest")) != null && !(suggestEntries = suggest.entrySet()).isEmpty()) {
                            SolrQueryIndex.this.putSuggestions(suggestEntries, this.queue, filter, configuration, solrServer);
                            this.noDocs = true;
                        }
                    }
                    catch (Exception e) {
                        if (!SolrQueryIndex.this.log.isWarnEnabled()) break block20;
                        SolrQueryIndex.this.log.warn("query via {} failed.", (Object)solrServer, (Object)e);
                    }
                }
                return !this.queue.isEmpty();
            }
        };
    }

    private void filterFacet(SolrDocument doc, FacetField facetField) {
        Collection docFieldValues;
        if (doc.getFieldNames().contains(facetField.getName()) && (docFieldValues = doc.getFieldValues(facetField.getName())) != null) {
            for (Object docFieldValue : docFieldValues) {
                String valueString = String.valueOf(docFieldValue);
                LinkedList<FacetField.Count> toRemove = new LinkedList<FacetField.Count>();
                for (FacetField.Count count : facetField.getValues()) {
                    long existingCount = count.getCount();
                    if (!valueString.equals(count.getName())) continue;
                    if (existingCount > 1L) {
                        count.setCount(existingCount - 1L);
                        continue;
                    }
                    toRemove.add(count);
                }
                for (FacetField.Count f : toRemove) {
                    assert (facetField.getValues().remove(f));
                }
            }
        }
    }

    private void putSpellChecks(SpellCheckResponse spellCheckResponse, Deque<SolrResultRow> queue, Filter filter, OakSolrConfiguration configuration, SolrClient solrServer) throws IOException, SolrServerException {
        List suggestions = spellCheckResponse.getSuggestions();
        ArrayList alternatives = new ArrayList(suggestions.size());
        for (SpellCheckResponse.Suggestion suggestion : suggestions) {
            alternatives.addAll(suggestion.getAlternatives());
        }
        block1: for (String alternative : alternatives) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setParam("q", new String[]{alternative});
            solrQuery.setParam("df", new String[]{configuration.getCatchAllField()});
            solrQuery.setParam("q.op", new String[]{"AND"});
            solrQuery.setParam("rows", new String[]{"100"});
            QueryResponse suggestQueryResponse = solrServer.query((SolrParams)solrQuery);
            SolrDocumentList results = suggestQueryResponse.getResults();
            if (results == null || results.getNumFound() <= 0L) continue;
            for (SolrDocument doc : results) {
                if (!filter.isAccessible(String.valueOf(doc.getFieldValue(configuration.getPathField())))) continue;
                queue.add(new SolrResultRow(alternative));
                continue block1;
            }
        }
    }

    private void putSuggestions(Set<Map.Entry<String, Object>> suggestEntries, Deque<SolrResultRow> queue, Filter filter, OakSolrConfiguration configuration, SolrClient solrServer) throws IOException, SolrServerException {
        HashSet<SimpleOrderedMap> retrievedSuggestions = new HashSet<SimpleOrderedMap>();
        for (Map.Entry<String, Object> suggester : suggestEntries) {
            SimpleOrderedMap suggestionResponses = (SimpleOrderedMap)suggester.getValue();
            for (Map.Entry suggestionResponse : suggestionResponses) {
                SimpleOrderedMap suggestionResults = (SimpleOrderedMap)suggestionResponse.getValue();
                for (Map.Entry suggestionResult : suggestionResults) {
                    ArrayList suggestions;
                    if (!"suggestions".equals(suggestionResult.getKey()) || (suggestions = (ArrayList)suggestionResult.getValue()).isEmpty()) continue;
                    for (SimpleOrderedMap suggestion : suggestions) {
                        retrievedSuggestions.add(suggestion);
                    }
                }
            }
        }
        block4: for (SimpleOrderedMap suggestion : retrievedSuggestions) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setParam("q", new String[]{String.valueOf(suggestion.get("term"))});
            solrQuery.setParam("df", new String[]{configuration.getCatchAllField()});
            solrQuery.setParam("q.op", new String[]{"AND"});
            solrQuery.setParam("rows", new String[]{"100"});
            QueryResponse suggestQueryResponse = solrServer.query((SolrParams)solrQuery);
            SolrDocumentList results = suggestQueryResponse.getResults();
            if (results == null || results.getNumFound() <= 0L) continue;
            for (SolrDocument doc : results) {
                if (!filter.isAccessible(String.valueOf(doc.getFieldValue(configuration.getPathField())))) continue;
                queue.add(new SolrResultRow(suggestion.get("term").toString(), Double.parseDouble(suggestion.get("weight").toString())));
                continue block4;
            }
        }
    }

    static boolean isIgnoredProperty(Filter.PropertyRestriction property, OakSolrConfiguration configuration) {
        if (NATIVE_LUCENE_QUERY.equals(property.propertyName) || NATIVE_SOLR_QUERY.equals(property.propertyName)) {
            return false;
        }
        return !configuration.useForPropertyRestrictions() || configuration.getUsedProperties().size() > 0 && !configuration.getUsedProperties().contains(property.propertyName) || property.propertyName.contains("/") || "rep:excerpt".equals(property.propertyName) || "oak:scoreExplanation".equals(property.propertyName) || "rep:facet".equals(property.propertyName) || ":localname".equals(property.propertyName) || property.propertyName.startsWith("function*") || configuration.getIgnoredProperties().contains(property.propertyName);
    }

    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        Collection<String> indexPaths = new SolrIndexLookup(rootState).collectIndexNodePaths(filter);
        ArrayList<QueryIndex.IndexPlan> plans = new ArrayList<QueryIndex.IndexPlan>(indexPaths.size());
        this.log.debug("looking for plans for paths : {}", indexPaths);
        for (String path : indexPaths) {
            LMSEstimator estimator;
            QueryIndex.IndexPlan plan;
            OakSolrConfiguration configuration = this.getConfiguration(path, rootState);
            SolrClient solrServer = this.getServer(path, rootState);
            this.log.debug("building plan for server {} and configuration {}", (Object)solrServer, (Object)configuration);
            if (configuration == null || solrServer == null || (plan = this.getIndexPlan(filter, configuration, estimator = this.getEstimator(path), sortOrder, path)) == null) continue;
            plans.add(plan);
        }
        return plans;
    }

    private OakSolrConfiguration getConfiguration(String path, NodeState rootState) {
        NodeState node = rootState;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        try {
            if (SolrIndexInitializer.isSolrIndexNode(node)) {
                if (node.hasChildNode("server")) {
                    return new OakSolrNodeStateConfiguration(node);
                }
                return this.fallbackOakSolrConfigurationProvider.getConfiguration();
            }
            if (node.exists()) {
                this.log.warn("Cannot open Solr Index at path {} as the index is not of type 'solr'", (Object)path);
            }
        }
        catch (Exception e) {
            this.log.error("Could not access the Solr index at " + path, (Throwable)e);
        }
        return null;
    }

    private QueryIndex.IndexPlan getIndexPlan(Filter filter, OakSolrConfiguration configuration, LMSEstimator estimator, List<QueryIndex.OrderEntry> sortOrder, String path) {
        if (this.getMatchingFilterRestrictions(filter, configuration) > 0) {
            ArrayList<QueryIndex.OrderEntry> sortOrder2 = new ArrayList<QueryIndex.OrderEntry>();
            if (sortOrder != null) {
                for (QueryIndex.OrderEntry e : sortOrder) {
                    if (e.getPropertyName().startsWith("function*")) continue;
                    sortOrder2.add(e);
                }
            }
            QueryIndex.IndexPlan indexPlan = this.planBuilder(filter).setEstimatedEntryCount(estimator.estimate(filter)).setSortOrder(sortOrder2).setPlanName(path).setPathPrefix(this.getPathPrefix(path)).build();
            this.log.debug("index plan {}", (Object)indexPlan);
            return indexPlan;
        }
        return null;
    }

    private String getPathPrefix(String indexPath) {
        String parentPath = PathUtils.getAncestorPath((String)indexPath, (int)2);
        return PathUtils.denotesRoot((String)parentPath) ? "" : parentPath;
    }

    private QueryIndex.IndexPlan.Builder planBuilder(Filter filter) {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(1.5).setCostPerEntry(0.3).setFilter(filter).setFulltextIndex(true).setIncludesNodeData(true).setDelayed(true);
    }

    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        return plan.toString();
    }

    public Cursor query(Filter filter, NodeState rootState) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Nullable
    public QueryIndex.NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    private class SolrRowCursor
    implements Cursor {
        private final Cursor pathCursor;
        private final QueryIndex.IndexPlan plan;
        private final LMSEstimator estimator;
        private final SolrClient solrServer;
        private final OakSolrConfiguration configuration;
        SolrResultRow currentRow;

        SolrRowCursor(final Iterator<SolrResultRow> it, QueryIndex.IndexPlan plan, QueryLimits settings, LMSEstimator estimator, SolrClient solrServer, final OakSolrConfiguration configuration) {
            this.estimator = estimator;
            this.solrServer = solrServer;
            this.configuration = configuration;
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    SolrRowCursor.this.currentRow = (SolrResultRow)it.next();
                    String path = SolrRowCursor.this.currentRow.path;
                    if (configuration.collapseJcrContentParents() && path.endsWith("jcr:content")) {
                        return PathUtils.getParentPath((String)path);
                    }
                    return path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.plan = plan;
            this.pathCursor = new PathCursor((Iterator)pathIterator, false, settings);
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public boolean isVirtualRow() {
                    return SolrRowCursor.this.currentRow.doc == null;
                }

                public String getPath() {
                    String sub = pathRow.getPath();
                    if (this.isVirtualRow()) {
                        return sub;
                    }
                    if (PathUtils.isAbsolute((String)sub)) {
                        return SolrRowCursor.this.plan.getPathPrefix() + sub;
                    }
                    return PathUtils.concat((String)SolrRowCursor.this.plan.getPathPrefix(), (String)sub);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public PropertyValue getValue(String columnName) {
                    String value;
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)SolrRowCursor.this.currentRow.score);
                    }
                    if (columnName.startsWith("rep:facet")) {
                        String facetFieldName = columnName.substring("rep:facet".length() + 1, columnName.length() - 1);
                        FacetField facetField = null;
                        for (FacetField ff : SolrRowCursor.this.currentRow.facetFields) {
                            if (!ff.getName().equals(facetFieldName + "_facet")) continue;
                            facetField = ff;
                            break;
                        }
                        if (facetField == null) return null;
                        JsopBuilder writer = new JsopBuilder();
                        writer.object();
                        for (FacetField.Count count : facetField.getValues()) {
                            writer.key(count.getName()).value(count.getCount());
                        }
                        writer.endObject();
                        return PropertyValues.newString((String)writer.toString());
                    }
                    if ("rep:spellcheck()".equals(columnName) || "rep:suggest()".equals(columnName)) {
                        return PropertyValues.newString((String)SolrRowCursor.this.currentRow.suggestion);
                    }
                    Collection fieldValues = SolrRowCursor.this.currentRow.doc.getFieldValues(columnName);
                    if (fieldValues != null && fieldValues.size() > 0) {
                        if (fieldValues.size() > 1) {
                            value = IterableUtils.toString((Iterable)fieldValues);
                            return PropertyValues.newString((String)value);
                        } else {
                            Object fieldValue = SolrRowCursor.this.currentRow.doc.getFieldValue(columnName);
                            if (fieldValue == null) return null;
                            value = fieldValue.toString();
                        }
                        return PropertyValues.newString((String)value);
                    } else {
                        value = IterableUtils.toString(Collections.emptyList());
                    }
                    return PropertyValues.newString((String)value);
                }
            };
        }

        public long getSize(Result.SizePrecision precision, long max) {
            long estimate = -1L;
            switch (precision) {
                case EXACT: {
                    SolrQuery countQuery = FilterQueryParser.getQuery(this.plan.getFilter(), this.plan, this.configuration);
                    countQuery.setRows(Integer.valueOf(0));
                    try {
                        estimate = this.solrServer.query((SolrParams)countQuery).getResults().getNumFound();
                    }
                    catch (IOException | SolrServerException e) {
                        SolrQueryIndex.this.log.warn("could not perform count query {}", (Object)countQuery);
                    }
                    break;
                }
                case APPROXIMATION: {
                    estimate = this.estimator.estimate(this.plan.getFilter());
                    break;
                }
                case FAST_APPROXIMATION: {
                    estimate = this.plan.getEstimatedEntryCount();
                }
            }
            return Math.min(estimate, max);
        }
    }

    static class SolrResultRow {
        final String path;
        final double score;
        final SolrDocument doc;
        final Collection<FacetField> facetFields;
        final String suggestion;

        private SolrResultRow(String path, double score, SolrDocument doc, String suggestion, Collection<FacetField> facetFields) {
            this.path = path;
            this.score = score;
            this.doc = doc;
            this.suggestion = suggestion;
            this.facetFields = facetFields;
        }

        SolrResultRow(String suggestion, double score) {
            this("/", score, null, suggestion, null);
        }

        SolrResultRow(String suggestion) {
            this("/", 1.0, null, suggestion, null);
        }

        SolrResultRow(String path, float score, SolrDocument doc, Collection<FacetField> facetFields) {
            this(path, score, doc, null, facetFields);
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

