/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collection;
import java.util.HashSet;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
class SolrIndexLookup {
    private static final Logger log = LoggerFactory.getLogger(SolrIndexLookup.class);
    private final NodeState root;

    SolrIndexLookup(NodeState root) {
        this.root = root;
    }

    Collection<String> collectIndexNodePaths(Filter filter) {
        return this.collectIndexNodePaths(filter, true);
    }

    private Collection<String> collectIndexNodePaths(Filter filter, boolean recurse) {
        HashSet<String> paths = new HashSet<String>();
        SolrIndexLookup.collectIndexNodePaths(this.root, "/", paths);
        if (recurse) {
            StringBuilder sb = new StringBuilder();
            NodeState nodeState = this.root;
            for (String element : PathUtils.elements((String)filter.getPath())) {
                nodeState = nodeState.getChildNode(element);
                SolrIndexLookup.collectIndexNodePaths(nodeState, sb.append("/").append(element).toString(), paths);
            }
        }
        return paths;
    }

    private static void collectIndexNodePaths(NodeState nodeState, String parentPath, Collection<String> paths) {
        NodeState state = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            if (!SolrIndexInitializer.isSolrIndexNode(entry.getNodeState())) continue;
            String indexNodePath = SolrIndexLookup.createIndexNodePath(parentPath, entry.getName());
            log.debug("found Solr index node at {}", (Object)indexNodePath);
            paths.add(indexNodePath);
        }
    }

    private static String createIndexNodePath(String parentPath, String name) {
        return PathUtils.concat((String)parentPath, (String[])new String[]{"oak:index", name});
    }
}

