/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
@Component(immediate=true, service={SolrServerProvider.class}, reference={@Reference(name="solrServerConfigurationProvider", service=SolrServerConfigurationProvider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, bind="bindSolrServerConfigurationProvider", unbind="unbindSolrServerConfigurationProvider", updated="updatedSolrServerConfigurationProvider")})
@Designate(ocd=Configuration.class)
public class SolrServerProviderService
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, SolrServerConfigurationProvider> solrServerConfigurationProviders = new HashMap<String, SolrServerConfigurationProvider>();
    private String serverType;
    private SolrClient cachedSolrServer;

    @Activate
    protected void activate(Configuration configuration) throws Exception {
        this.serverType = configuration.server_type().toString();
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrServerConfigurationProviders.clear();
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.cachedSolrServer != null) {
            try {
                this.cachedSolrServer.close();
            }
            catch (Exception e) {
                this.log.error("could not correctly shutdown Solr {} server {}", (Object)this.serverType, (Object)this.cachedSolrServer);
            }
            finally {
                this.cachedSolrServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.put(name, solrServerConfigurationProvider);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.remove(name);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.put(name, solrServerConfigurationProvider);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SolrClient getSolrServer() throws Exception {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            if (this.cachedSolrServer == null) {
                this.cachedSolrServer = this.getServer();
            }
            return this.cachedSolrServer;
        }
    }

    @Override
    @Nullable
    public SolrClient getIndexingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    @Override
    @Nullable
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private SolrClient getServer() {
        SolrServerConfigurationProvider solrServerConfigurationProvider;
        OakSolrServer solrServer = null;
        if (this.serverType != null && !"none".equals(this.serverType) && (solrServerConfigurationProvider = this.solrServerConfigurationProviders.get(this.serverType)) != null) {
            try {
                solrServer = new OakSolrServer(solrServerConfigurationProvider);
                this.log.info("created new SolrServer {}", (Object)solrServer);
            }
            catch (Exception e) {
                this.log.error("could not get a SolrServerProvider of type {}", (Object)this.serverType, (Object)e);
            }
        }
        return solrServer;
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.solr.osgi.SolrServerProviderService", name="Apache Jackrabbit Oak Solr server provider")
    static @interface Configuration {
        @AttributeDefinition(name="Property server.type", options={@Option(value="none", label="None"), @Option(value="embedded", label="Embedded Solr"), @Option(value="remote", label="Remote Solr")})
        public OakSolrConfiguration.ServerType server_type() default OakSolrConfiguration.ServerType.none;
    }
}

