/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
@Component(immediate=true)
@Designate(ocd=Configuration.class)
public class SolrQueryIndexProviderService {
    private static final boolean QUERY_TIME_AGGREGATION_DEFAULT = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
    @Reference
    private SolrServerProvider solrServerProvider;
    @Reference
    private OakSolrConfigurationProvider oakSolrConfigurationProvider;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private volatile QueryIndex.NodeAggregator nodeAggregator;

    @Activate
    protected void activate(ComponentContext componentContext, Configuration configuration) {
        boolean queryTimeAggregation = configuration.query_aggregation();
        if (this.solrServerProvider != null && this.oakSolrConfigurationProvider != null) {
            SolrQueryIndexProvider solrQueryIndexProvider = new SolrQueryIndexProvider(this.solrServerProvider, this.oakSolrConfigurationProvider, this.nodeAggregator);
            this.log.debug("creating Solr query index provider {} query time aggregation", (Object)(queryTimeAggregation ? "with" : "without"));
            if (queryTimeAggregation) {
                solrQueryIndexProvider = AggregateIndexProvider.wrap((QueryIndexProvider)solrQueryIndexProvider);
            }
            this.regs.add(componentContext.getBundleContext().registerService(QueryIndexProvider.class.getName(), (Object)solrQueryIndexProvider, null));
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration registration : this.regs) {
            registration.unregister();
        }
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.solr.osgi.SolrQueryIndexProviderService", name="Apache Jackrabbit Oak Solr Query index provider configuration")
    static @interface Configuration {
        @AttributeDefinition(name="query time aggregation", description="enable query time aggregation for Solr index")
        public boolean query_aggregation() default true;
    }
}

