/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.RemoteSolrServerProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Deprecated(forRemoval=true, since="1.74.0")
@Component(immediate=true, service={SolrServerConfigurationProvider.class})
@Designate(ocd=Configuration.class)
public class RemoteSolrServerConfigurationProvider
implements SolrServerConfigurationProvider<RemoteSolrServerProvider> {
    private String solrHttpUrl;
    private String solrZkHost;
    private String solrCollection;
    private Integer solrShardsNo;
    private Integer solrReplicationFactor;
    private String solrConfDir;
    private RemoteSolrServerConfiguration remoteSolrServerConfiguration;

    @Activate
    protected void activate(Configuration configuration) throws Exception {
        this.solrHttpUrl = configuration.solr_http_url();
        this.solrZkHost = configuration.solr_zk_host();
        this.solrCollection = configuration.solr_collection();
        this.solrShardsNo = configuration.solr_shards_no();
        this.solrReplicationFactor = configuration.solr_replication_factor();
        this.solrConfDir = configuration.solr_conf_dir();
        int socketTimeout = configuration.solr_socket_timeout();
        int connectionTimeout = configuration.solr_connection_timeout();
        this.remoteSolrServerConfiguration = new RemoteSolrServerConfiguration(this.solrZkHost, this.solrCollection, this.solrShardsNo, this.solrReplicationFactor, this.solrConfDir, socketTimeout, connectionTimeout, this.solrHttpUrl);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrHttpUrl = null;
        this.solrZkHost = null;
        this.solrCollection = null;
        this.solrShardsNo = 0;
        this.solrReplicationFactor = 0;
        this.solrConfDir = null;
    }

    @Override
    @NotNull
    public SolrServerConfiguration<RemoteSolrServerProvider> getSolrServerConfiguration() {
        return this.remoteSolrServerConfiguration;
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.solr.osgi.RemoteSolrServerConfigurationProvider", name="Apache Jackrabbit Oak Solr remote server configuration")
    static @interface Configuration {
        @AttributeDefinition(name="Solr HTTP URL")
        public String solr_http_url() default "http://127.0.0.1:8983/solr/oak";

        @AttributeDefinition(name="ZooKeeper host")
        public String solr_zk_host() default "127.0.0.1:9983";

        @AttributeDefinition(name="Solr collection")
        public String solr_collection() default "oak";

        @AttributeDefinition(name="Socket timeout (ms)")
        public int solr_socket_timeout() default 3000;

        @AttributeDefinition(name="Connection timeout (ms)")
        public int solr_connection_timeout() default 3000;

        @AttributeDefinition(name="No. of collection shards")
        public int solr_shards_no() default 2;

        @AttributeDefinition(name="Replication factor")
        public int solr_replication_factor() default 2;

        @AttributeDefinition(name="Solr configuration directory")
        public String solr_conf_dir() default "";

        public String name() default "remote";
    }
}

