/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Deprecated(forRemoval=true, since="1.74.0")
@Component(immediate=true, service={OakSolrConfigurationProvider.class})
@Designate(ocd=Configuration.class)
public class OakSolrConfigurationProviderService
implements OakSolrConfigurationProvider {
    private String pathChildrenFieldName;
    private String pathParentFieldName;
    private String pathDescendantsFieldName;
    private String pathExactFieldName;
    private String collapsedPathField;
    private String catchAllField;
    private OakSolrConfiguration.CommitPolicy commitPolicy;
    private int rows;
    private boolean useForPathRestrictions;
    private boolean useForPropertyRestrictions;
    private boolean useForPrimaryTypes;
    private String[] ignoredProperties;
    private String[] usedProperties;
    private String[] typeMappings;
    private String[] propertyMappings;
    private boolean collapseJcrContentNodes;
    private boolean collapseJcrContentParents;
    private String depthField;
    private OakSolrConfiguration oakSolrConfiguration;

    @Activate
    protected void activate(Configuration configuration) {
        this.pathChildrenFieldName = configuration.path_child_field();
        this.pathParentFieldName = configuration.path_parent_field();
        this.pathExactFieldName = configuration.path_exact_field();
        this.collapsedPathField = configuration.collapsed_path_field();
        this.pathDescendantsFieldName = configuration.path_desc_field();
        this.catchAllField = configuration.catch_all_field();
        this.depthField = configuration.path_depth_field();
        this.rows = configuration.rows();
        this.commitPolicy = configuration.commit_policy();
        this.useForPathRestrictions = configuration.path_restrictions();
        this.useForPropertyRestrictions = configuration.property_restrictions();
        this.useForPrimaryTypes = configuration.primarytypes_restrictions();
        this.typeMappings = configuration.type_mappings();
        this.ignoredProperties = configuration.ignored_properties();
        this.usedProperties = configuration.used_properties();
        this.propertyMappings = configuration.property_mappings();
        this.collapseJcrContentNodes = configuration.collapse_jcrcontent_nodes();
        this.collapseJcrContentParents = configuration.collapse_jcrcontent_parents();
    }

    @Deactivate
    protected void deactivate() {
        this.oakSolrConfiguration = null;
    }

    @Override
    @NotNull
    public OakSolrConfiguration getConfiguration() {
        if (this.oakSolrConfiguration == null) {
            this.oakSolrConfiguration = new OakSolrConfiguration(){

                @Override
                public String getFieldNameFor(Type<?> propertyType) {
                    for (String typeMapping : OakSolrConfigurationProviderService.this.typeMappings) {
                        Type type;
                        String[] mapping = typeMapping.split("=");
                        if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || (type = Type.fromString((String)mapping[0])) == null || type.tag() != propertyType.tag()) continue;
                        return mapping[1];
                    }
                    return null;
                }

                @Override
                public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
                    for (String propertyMapping : OakSolrConfigurationProviderService.this.propertyMappings) {
                        String[] mapping = propertyMapping.split("=");
                        if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || !mapping[0].equals(propertyRestriction.propertyName)) continue;
                        return mapping[1];
                    }
                    return null;
                }

                @Override
                @NotNull
                public String getPathField() {
                    return OakSolrConfigurationProviderService.this.pathExactFieldName;
                }

                @Override
                @Nullable
                public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
                    String fieldName = null;
                    switch (pathRestriction) {
                        case ALL_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathDescendantsFieldName;
                            break;
                        }
                        case DIRECT_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathChildrenFieldName;
                            break;
                        }
                        case EXACT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathExactFieldName;
                            break;
                        }
                        case PARENT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathParentFieldName;
                            break;
                        }
                        case NO_RESTRICTION: {
                            break;
                        }
                    }
                    return fieldName;
                }

                @Override
                @NotNull
                public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                    return OakSolrConfigurationProviderService.this.commitPolicy;
                }

                @Override
                public String getCatchAllField() {
                    return OakSolrConfigurationProviderService.this.catchAllField;
                }

                @Override
                public int getRows() {
                    return OakSolrConfigurationProviderService.this.rows;
                }

                @Override
                public boolean useForPropertyRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPropertyRestrictions;
                }

                @Override
                public boolean useForPrimaryTypes() {
                    return OakSolrConfigurationProviderService.this.useForPrimaryTypes;
                }

                @Override
                public boolean useForPathRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPathRestrictions;
                }

                @Override
                @NotNull
                public Collection<String> getIgnoredProperties() {
                    if (OakSolrConfigurationProviderService.this.ignoredProperties != null && OakSolrConfigurationProviderService.this.ignoredProperties.length > 0 && OakSolrConfigurationProviderService.this.ignoredProperties[0].length() > 0) {
                        return Arrays.asList(OakSolrConfigurationProviderService.this.ignoredProperties);
                    }
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public Collection<String> getUsedProperties() {
                    if (OakSolrConfigurationProviderService.this.usedProperties != null && OakSolrConfigurationProviderService.this.usedProperties.length > 0 && OakSolrConfigurationProviderService.this.usedProperties[0].length() > 0) {
                        return Arrays.asList(OakSolrConfigurationProviderService.this.usedProperties);
                    }
                    return Collections.emptyList();
                }

                @Override
                public boolean collapseJcrContentNodes() {
                    return OakSolrConfigurationProviderService.this.collapseJcrContentNodes;
                }

                @Override
                public boolean collapseJcrContentParents() {
                    return OakSolrConfigurationProviderService.this.collapseJcrContentParents;
                }

                @Override
                @NotNull
                public String getCollapsedPathField() {
                    return OakSolrConfigurationProviderService.this.collapsedPathField;
                }

                @Override
                public String getPathDepthField() {
                    return OakSolrConfigurationProviderService.this.depthField;
                }
            };
        }
        return this.oakSolrConfiguration;
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.solr.osgi.OakSolrConfigurationProviderService", name="Apache Jackrabbit Oak Solr indexing / search configuration")
    static @interface Configuration {
        @AttributeDefinition(name="field for descendants search")
        public String path_desc_field() default "path_des";

        @AttributeDefinition(name="field for children search")
        public String path_child_field() default "path_child";

        @AttributeDefinition(name="field for parent search")
        public String path_parent_field() default "path_anc";

        @AttributeDefinition(name="field for path search")
        public String path_exact_field() default "path_exact";

        @AttributeDefinition(name="catch all field")
        public String catch_all_field() default "catch_all";

        @AttributeDefinition(name="field for collapsing jcr:content paths")
        public String collapsed_path_field() default "path_collapsed";

        @AttributeDefinition(name="field for path depth")
        public String path_depth_field() default "path_depth";

        @AttributeDefinition(name="Property commit.policy", options={@Option(value="HARD", label="Hard commit"), @Option(value="SOFT", label="Soft commit"), @Option(value="AUTO", label="Auto commit")})
        public OakSolrConfiguration.CommitPolicy commit_policy() default OakSolrConfiguration.CommitPolicy.SOFT;

        @AttributeDefinition(name="rows")
        public int rows() default 10;

        @AttributeDefinition(name="path restrictions")
        public boolean path_restrictions() default false;

        @AttributeDefinition(name="property restrictions")
        public boolean property_restrictions() default false;

        @AttributeDefinition(name="primary types restrictions")
        public boolean primarytypes_restrictions() default false;

        @AttributeDefinition(name="ignored properties")
        public String[] ignored_properties() default {"rep:members", "rep:authorizableId", "jcr:uuid", "rep:principalName", "rep:password"};

        @AttributeDefinition(name="used properties")
        public String[] used_properties();

        @AttributeDefinition(name="mappings from Oak Types to Solr fields", description="each item should be in the form TypeString=FieldName (e.g. STRING=text_general)", cardinality=13)
        public String[] type_mappings() default {""};

        @AttributeDefinition(name="mappings from JCR property names to Solr fields", description="each item should be in the form PropertyName=FieldName (e.g. jcr:title=text_en)")
        public String[] property_mappings() default {""};

        @AttributeDefinition(name="collapse jcr:content nodes")
        public boolean collapse_jcrcontent_nodes() default false;

        @AttributeDefinition(name="collapse jcr:content parents")
        public boolean collapse_jcrcontent_parents() default true;
    }
}

