/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import java.io.IOException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DiffObserver;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
public class NodeStateSolrServersObserver
extends DiffObserver {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected NodeStateDiff getRootDiff(@NotNull NodeState before, @NotNull NodeState after, @NotNull CommitInfo info) {
        return new ChangingSolrServersNodeStateDiff(after);
    }

    private void shutdownRegisteredSolrServers(NodeState nodeState) {
        this.log.debug("shutting down persisted Solr server");
        NodeStateSolrServerConfigurationProvider nodeStateSolrServerConfigurationProvider = new NodeStateSolrServerConfigurationProvider(nodeState);
        OakSolrServer oakSolrServer = new OakSolrServer(nodeStateSolrServerConfigurationProvider);
        try {
            oakSolrServer.close();
        }
        catch (IOException e) {
            this.log.error("could not close OakSolrServer {}", (Object)oakSolrServer, (Object)e);
        }
        this.log.info("persisted Solr server has been shutdown");
    }

    private class ChangingSolrServersNodeStateDiff
    implements NodeStateDiff {
        private final NodeState nodeState;
        private final String name;

        public ChangingSolrServersNodeStateDiff(NodeState after) {
            this.nodeState = after;
            this.name = "";
        }

        public ChangingSolrServersNodeStateDiff(NodeState nodeState, String name) {
            this.nodeState = nodeState;
            this.name = name;
        }

        public boolean propertyAdded(PropertyState after) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (this.isSolrServerNode(name, before)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(before);
            }
            return after.compareAgainstBaseState(before, (NodeStateDiff)new ChangingSolrServersNodeStateDiff(after, this.name + "/" + name));
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            if (this.isSolrServerNode(name, before)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(before);
            } else {
                for (String childNodeName : before.getChildNodeNames()) {
                    NodeState childNodeState;
                    if (!this.isSolrServerNode(childNodeName, childNodeState = before.getChildNode(childNodeName))) continue;
                    NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(childNodeState);
                    break;
                }
            }
            return true;
        }

        private boolean isSolrServerNode(String name, NodeState nodeState) {
            return "server".equals(name) && nodeState.hasProperty("solrServerType");
        }
    }
}

