/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="1.74.0")
public class EmbeddedSolrServerProvider
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EmbeddedSolrServerConfiguration solrServerConfiguration;

    public EmbeddedSolrServerProvider(EmbeddedSolrServerConfiguration solrServerConfiguration) {
        this.solrServerConfiguration = solrServerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrClient createSolrServer() throws Exception {
        this.log.info("creating new embedded solr server with config: {}", (Object)this.solrServerConfiguration);
        String solrHomePath = this.solrServerConfiguration.getSolrHomePath();
        String coreName = this.solrServerConfiguration.getCoreName();
        EmbeddedSolrServerConfiguration.HttpConfiguration httpConfiguration = this.solrServerConfiguration.getHttpConfiguration();
        if (solrHomePath != null && coreName != null) {
            this.checkSolrConfiguration(solrHomePath, coreName);
            if (httpConfiguration != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting embedded Solr server with http bindings");
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(JettySolrRunner.class.getClassLoader());
                Integer httpPort = httpConfiguration.getHttpPort();
                String context = httpConfiguration.getContext();
                JettySolrRunner jettySolrRunner = null;
                try {
                    jettySolrRunner = new JettySolrRunner(solrHomePath, context, httpPort.intValue());
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner instantiated");
                    }
                    jettySolrRunner.start();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner started");
                    }
                }
                catch (Exception t) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("an error has occurred while starting Solr Jetty", (Throwable)t);
                    }
                }
                finally {
                    block30: {
                        if (jettySolrRunner != null && !jettySolrRunner.isRunning()) {
                            try {
                                jettySolrRunner.stop();
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Jetty runner stopped");
                                }
                            }
                            catch (Exception e) {
                                if (!this.log.isErrorEnabled()) break block30;
                                this.log.error("error while stopping the Jetty runner", (Throwable)e);
                            }
                        }
                    }
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting HTTP Solr server");
                }
                return new HttpWithJettySolrServer("http://127.0.0.1:" + httpPort + context + "/" + coreName, jettySolrRunner);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CoreContainer.class.getClassLoader());
            CoreContainer coreContainer = null;
            try {
                Path path = FileSystems.getDefault().getPath(solrHomePath, new String[0]);
                coreContainer = CoreContainer.createAndLoad((Path)path);
                if (!coreContainer.isLoaded(coreName)) {
                    coreContainer.load();
                }
            }
            catch (Exception e) {
                this.log.error("cannot load core {}, shutting down embedded Solr..", (Object)coreName, (Object)e);
                try {
                    coreContainer.shutdown();
                }
                catch (Exception se) {
                    this.log.error("could not shutdown embedded Solr", (Throwable)se);
                }
                SolrClient solrClient = null;
                return solrClient;
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            EmbeddedSolrServer server = new EmbeddedSolrServer(coreContainer, coreName);
            if (server.ping().getStatus() == 0) {
                return server;
            }
            throw new IOException("the embedded Solr server is not alive");
        }
        throw new Exception("SolrServer configuration proprties not set");
    }

    private void checkSolrConfiguration(String solrHomePath, String coreName) throws IOException {
        Object[] files;
        File solrHomePathFile = new File(solrHomePath);
        this.log.info("checking configuration at {}", (Object)solrHomePathFile.getAbsolutePath());
        if (!solrHomePathFile.exists()) {
            if (!solrHomePathFile.mkdirs()) {
                throw new IOException("could not create solrHomePath directory");
            }
            this.copy("/solr/solr.xml", solrHomePath);
            this.copy("/solr/zoo.cfg", solrHomePath);
        } else if (!solrHomePathFile.isDirectory()) {
            throw new IOException("a non directory file with the specified name already exists for the given solrHomePath '" + solrHomePath);
        }
        File solrCorePathFile = new File(solrHomePathFile, coreName);
        if (!solrCorePathFile.exists()) {
            if (!new File(solrCorePathFile, "conf").mkdirs()) {
                throw new IOException("could not create nested core directory in solrHomePath/solrCoreName/conf");
            }
            String solrCoreDir = solrCorePathFile.getAbsolutePath();
            File coreProperties = new File(new File(solrCoreDir), "core.properties");
            assert (coreProperties.createNewFile());
            FileOutputStream out = new FileOutputStream(coreProperties);
            IOUtils.writeBytes((OutputStream)out, (byte[])("name=" + coreName).getBytes("UTF-8"));
            out.flush();
            out.close();
            String coreConfDir = solrCoreDir + "/conf/";
            this.copy("/solr/oak/conf/schema.xml", coreConfDir);
            this.copy("/solr/oak/conf/solrconfig.xml", coreConfDir);
        } else if (!solrCorePathFile.isDirectory()) {
            throw new IOException("a non directory file with the specified name already exists for the given Solr core path'" + solrCorePathFile.getAbsolutePath());
        }
        File solrDataPathFile = new File(solrHomePathFile + "/" + coreName + "/data/index");
        if (solrDataPathFile.exists()) {
            this.log.debug("deleting stale lock files");
            File[] locks = solrDataPathFile.listFiles((dir, name) -> "write.lock".equals(name));
            this.log.debug("found {} lock files", (Object)locks.length);
            if (locks.length > 0) {
                for (File f : locks) {
                    FileUtils.forceDelete((File)f);
                    this.log.debug("deleted {}", (Object)f.getAbsolutePath());
                }
            }
        }
        if ((files = solrHomePathFile.list()) != null) {
            Arrays.sort(files);
            if (Arrays.binarySearch(files, coreName) < 0) {
                throw new IOException("could not find a directory with the coreName '" + coreName + "' in the solrHomePath '" + solrHomePath + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resource, String dir) throws IOException {
        String fileName = dir + resource.substring(resource.lastIndexOf("/"));
        File outputFile = new File(fileName);
        if (outputFile.createNewFile()) {
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(resource);
                outputStream = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Nullable
    public SolrClient getSolrServer() throws Exception {
        return this.createSolrServer();
    }

    @Nullable
    public SolrClient getIndexingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    @Nullable
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    public void close() throws IOException {
    }

    private class HttpWithJettySolrServer
    extends HttpSolrClient {
        private final JettySolrRunner jettySolrRunner;

        public HttpWithJettySolrServer(String s, JettySolrRunner jettySolrRunner) {
            super(new HttpSolrClient.Builder(s));
            this.jettySolrRunner = jettySolrRunner;
        }

        public void close() throws IOException {
            super.close();
            try {
                if (this.jettySolrRunner != null && this.jettySolrRunner.isRunning()) {
                    this.jettySolrRunner.stop();
                }
            }
            catch (Exception e) {
                EmbeddedSolrServerProvider.this.log.warn("could not stop JettySolrRunner {}", (Object)this.jettySolrRunner);
            }
        }
    }
}

