/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.SimpleNodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.DefaultSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.query.AbstractQueryTest;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

@Deprecated(forRemoval=true, since="1.74.0")
public class SolrIndexIT
extends AbstractQueryTest {
    @Rule
    public TestName name = new TestName();

    protected void createTestIndexNode() throws Exception {
        Tree index = this.root.getTree("/");
        Tree solrIndexNode = SolrIndexIT.createTestIndexNode((Tree)index, (String)"solr");
        solrIndexNode.setProperty("pathRestrictions", (Object)true);
        solrIndexNode.setProperty("propertyRestrictions", (Object)true);
        solrIndexNode.setProperty("primaryTypes", (Object)true);
        solrIndexNode.setProperty("commitPolicy", (Object)"hard");
        Tree server = solrIndexNode.addChild("server");
        server.setProperty("solrServerType", (Object)"embedded");
        server.setProperty("solrHomePath", (Object)("target/" + this.name.getMethodName()));
        this.root.commit();
    }

    protected ContentRepository createRepository() {
        try {
            DefaultSolrServerProvider solrServerProvider = new DefaultSolrServerProvider();
            DefaultSolrConfigurationProvider oakSolrConfigurationProvider = new DefaultSolrConfigurationProvider();
            return new Oak().with((RepositoryInitializer)new InitialContent()).with((SecurityProvider)new OpenSecurityProvider()).with((QueryIndexProvider)new SolrQueryIndexProvider((SolrServerProvider)solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider, (QueryIndex.NodeAggregator)new SimpleNodeAggregator())).with((IndexEditorProvider)new SolrIndexEditorProvider((SolrServerProvider)solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider)).createContentRepository();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void sql1() throws Exception {
        this.test("sql1.txt");
    }

    @Test
    public void sql2() throws Exception {
        this.test("sql2.txt");
    }

    @Test
    public void sql2FullText() throws Exception {
        this.test("sql2-fulltext.txt");
    }

    @Test
    @Ignore(value="OAK-420")
    public void sql2Measure() throws Exception {
        this.test("sql2_measure.txt");
    }

    @Test
    public void descendantTest() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").addChild("c");
        test.addChild("b").addChild("d");
        this.root.commit();
        Iterator result = this.executeQuery("select [jcr:path] from [nt:base] where isdescendantnode('/test')", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a/c", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b/d", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void descendantTest2() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").addChild("c").setProperty("name", Arrays.asList("Hello", "World"), Type.STRINGS);
        test.addChild("b").setProperty("name", (Object)"Hello");
        this.root.commit();
        Iterator result = this.executeQuery("select [jcr:path] from [nt:base] where isdescendantnode('/test') and name='World'", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a/c", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void ischildnodeTest() throws Exception {
        Tree tree = this.root.getTree("/");
        Tree parents = tree.addChild("parents");
        parents.addChild("p0").setProperty("id", (Object)"0");
        parents.addChild("p1").setProperty("id", (Object)"1");
        parents.addChild("p2").setProperty("id", (Object)"2");
        Tree children = tree.addChild("children");
        children.addChild("c1").setProperty("p", (Object)"1");
        children.addChild("c2").setProperty("p", (Object)"2");
        children.addChild("c3").setProperty("p", (Object)"3");
        children.addChild("c4").setProperty("p", (Object)"4");
        this.root.commit();
        Iterator result = this.executeQuery("select p.[jcr:path], p2.[jcr:path] from [nt:base] as p inner join [nt:base] as p2 on ischildnode(p2, p) where p.[jcr:path] = '/'", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/, /children", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/, /jcr:system", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/, /oak:index", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/, /parents", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void ischildnodeTest2() throws Exception {
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("jcr:resource").addChild("x");
        test.addChild("resource");
        this.root.commit();
        Iterator strings = this.executeQuery("select [jcr:path] from [nt:base] as b where ischildnode(b, '/test')", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/jcr:resource", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/resource", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testNativeSolrQuery() throws Exception {
        String nativeQueryString = "select [jcr:path] from [nt:base] where native('solr', 'name:(Hello OR World)')";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("a").setProperty("name", (Object)"Hello");
        test.addChild("b").setProperty("name", (Object)"World");
        test.addChild("c");
        this.root.commit();
        Iterator strings = this.executeQuery(nativeQueryString, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/a", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/b", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testNativeSolrFunctionQuery() throws Exception {
        String nativeQueryString = "select [jcr:path] from [nt:base] where native('solr', 'path_child:\\/test  _val_:\"recip(rord(name),1,2,3)\"')";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("a").setProperty("name", (Object)"Hello");
        test.addChild("b").setProperty("name", (Object)"World");
        tree.addChild("c");
        this.root.commit();
        Iterator strings = this.executeQuery(nativeQueryString, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/a", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/b", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testNativeSolrLocalParams() throws Exception {
        String nativeQueryString = "select [jcr:path] from [nt:base] where native('solr', '_query_:\"{!dismax qf=catch_all q.op=OR}hello world\"')";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("a").setProperty("name", (Object)"Hello");
        test.addChild("b").setProperty("name", (Object)"World");
        test.addChild("c");
        this.root.commit();
        Iterator strings = this.executeQuery(nativeQueryString, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/a", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/b", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testNativeMLTQuery() throws Exception {
        String nativeQueryString = "select [jcr:path] from [nt:base] where native('solr', 'mlt?q=text:welt&mlt.fl=text&mlt.mindf=1&mlt.mintf=1')";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("a").setProperty("text", (Object)"Hello World today weather is nice");
        test.addChild("b").setProperty("text", (Object)"Cheers World today weather is quite nice");
        test.addChild("c").setProperty("text", (Object)"Halo Welt today sky is cloudy");
        this.root.commit();
        Iterator strings = this.executeQuery(nativeQueryString, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/a", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/b", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testNativeMLTQueryWithStream() throws Exception {
        String nativeQueryString = "select [jcr:path] from [nt:base] where native('solr', 'mlt?stream.body=sky is cloudy&mlt.fl=text&mlt.mindf=0&mlt.mintf=0')";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        test.addChild("a").setProperty("text", (Object)"Hello World, today weather is nice");
        test.addChild("b").setProperty("text", (Object)"Cheers World, today weather is quite nice");
        test.addChild("c").setProperty("text", (Object)"Halo Welt, today sky is cloudy");
        this.root.commit();
        Iterator strings = this.executeQuery(nativeQueryString, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/a", strings.next());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertEquals((Object)"/test/b", strings.next());
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void testRepSimilarXPathQuery() throws Exception {
        String query = "//element(*, nt:base)[rep:similar(., '/test/a')]";
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("text", (Object)"the quick brown fox jumped over the lazy white dog");
        test.addChild("b").setProperty("text", (Object)"I am a dog");
        test.addChild("c").setProperty("text", (Object)"dogs don't hurt");
        test.addChild("d").setProperty("text", (Object)"white men can't jump");
        test.addChild("e").setProperty("text", (Object)"the fox is brown");
        test.addChild("f").setProperty("text", (Object)"a quickest dog jumped over the quick white dog");
        test.addChild("g").setProperty("text", (Object)"hello world");
        test.addChild("h").setProperty("text", (Object)"over the lazy top");
        this.root.commit();
        Iterator result = this.executeQuery(query, "xpath").iterator();
        Object list = "";
        while (result.hasNext()) {
            String p = (String)result.next();
            if (p.startsWith("/oak:index")) continue;
            list = (String)list + p + " ";
        }
        Assert.assertEquals((Object)"/test/b /test/d /test/e /test/f /test/h ", (Object)list);
    }

    @Test
    public void nativeSolr() throws Exception {
        this.test("native_solr.txt");
    }

    @Test
    public void testTokenizeCN() throws Exception {
        Tree t = this.root.getTree("/").addChild("containsCN");
        Tree one = t.addChild("one");
        one.setProperty("t", (Object)"\u7f8e\u5973\u886c\u886b");
        this.root.commit();
        this.assertQuery("//*[jcr:contains(., '\u7f8e\u5973')]", "xpath", List.of(one.getPath()));
    }

    @Test
    @Ignore(value="OAK-9261")
    public void testCompositeRepExcerpt() throws Exception {
        String sqlQuery = "select [jcr:path], [jcr:score], [rep:excerpt] from [nt:base] as a where (contains([jcr:content/*], 'square') or contains([jcr:content/jcr:title], 'square') or contains([jcr:content/jcr:description], 'square')) and isdescendantnode(a, '/test') order by [jcr:score] desc";
        Tree tree = this.root.getTree("/");
        Tree test = tree.addChild("test");
        Tree child = test.addChild("child");
        Tree a = child.addChild("a");
        a.setProperty("jcr:title", (Object)"Hello World, today square is nice");
        Tree b = child.addChild("b");
        b.setProperty("jcr:description", (Object)"Cheers World, today weather is squary nice");
        Tree c = child.addChild("c");
        c.setProperty("jcr:title", (Object)"Halo Welt, today sky is square");
        this.root.commit();
        Iterator strings = this.executeQuery(sqlQuery, "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertTrue((boolean)((String)strings.next()).startsWith("/test/child,"));
        Assert.assertFalse((boolean)strings.hasNext());
    }

    @Test
    public void contains() throws Exception {
        String h = "Hello" + System.currentTimeMillis();
        String w = "World" + System.currentTimeMillis();
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("name", Arrays.asList(h, w), Type.STRINGS);
        test.addChild("b").setProperty("name", (Object)h);
        this.root.commit();
        StringBuffer stmt = new StringBuffer();
        stmt.append("/jcr:root//*[jcr:contains(., '").append(h);
        stmt.append("')]");
        this.assertQuery(stmt.toString(), "xpath", List.of("/test/a", "/test/b"));
        stmt = new StringBuffer();
        stmt.append("/jcr:root//*[jcr:contains(., '").append(w);
        stmt.append("')]");
        this.assertQuery(stmt.toString(), "xpath", List.of("/test/a"));
    }

    @Test
    @Ignore(value="depends on chosen text_general tokenizer")
    public void containsDash() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("name", (Object)"hello-wor");
        test.addChild("b").setProperty("name", (Object)"hello-world");
        test.addChild("c").setProperty("name", (Object)"hello");
        this.root.commit();
        this.assertQuery("/jcr:root//*[jcr:contains(., 'hello-wor*')]", "xpath", List.of("/test/a", "/test/b"));
        this.assertQuery("/jcr:root//*[jcr:contains(., '*hello-wor*')]", "xpath", List.of("/test/a", "/test/b"));
    }

    @Test
    public void multiPhraseQuery() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("dc:format", (Object)"type:application/pdf");
        this.root.commit();
        this.assertQuery("/jcr:root//*[jcr:contains(@dc:format, 'type:appli*')]", "xpath", List.of("/test/a"));
    }

    @Test
    public void testFulltextOperators() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("text", (Object)"the lazy fox jumped over the brown dog");
        test.addChild("b").setProperty("text", (Object)"the lazy bones raised to eat a dog");
        this.root.commit();
        this.assertQuery("/jcr:root//*[jcr:contains(., 'lazy AND brown')]", "xpath", List.of("/test/a"));
        this.assertQuery("/jcr:root//*[jcr:contains(., 'lazy OR eat')]", "xpath", List.of("/test/a", "/test/b"));
        this.assertQuery("/jcr:root//*[jcr:contains(., 'lazy AND bones')]", "xpath", List.of("/test/b"));
        this.assertQuery("/jcr:root//*[jcr:contains(., 'lazy OR dog')]", "xpath", List.of("/test/a", "/test/b"));
    }

    @Test
    public void containsPath() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").setProperty("name", (Object)"/parent/child/node");
        this.root.commit();
        this.assertQuery("//*[jcr:contains(., '/parent/child')]", "xpath", List.of("/test/a"));
    }

    @Test
    public void containsPathNum() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        Tree a = test.addChild("a");
        a.setProperty("name", (Object)"/segment1/segment2/segment3");
        this.root.commit();
        this.assertQuery("//*[jcr:contains(., '/segment1/segment2')]", "xpath", List.of("/test/a"));
    }

    @Test
    public void testOAK1208() throws Exception {
        Tree t = this.root.getTree("/").addChild("containsWithMultipleOr");
        Tree one = t.addChild("one");
        one.setProperty("p", (Object)"dam/smartcollection");
        one.setProperty("t", (Object)"media");
        Tree two = t.addChild("two");
        two.setProperty("p", (Object)"dam/collection");
        two.setProperty("t", (Object)"media");
        Tree three = t.addChild("three");
        three.setProperty("p", (Object)"dam/hits");
        three.setProperty("t", (Object)"media");
        this.root.commit();
        this.assertQuery("//*[jcr:contains(., 'media') and (@p = 'dam/smartcollection' or @p = 'dam/collection') ]", "xpath", List.of(one.getPath(), two.getPath()));
    }

    @Test
    public void testSortingOnPath() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        test.addChild("a").addChild("c");
        test.addChild("b").addChild("d");
        this.root.commit();
        Iterator result = this.executeQuery("select [jcr:path] from [nt:base] where isdescendantnode('/test') order by [jcr:path] asc", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a/c", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b/d", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testSortingOnProperty() throws Exception {
        Tree test = this.root.getTree("/").addChild("test");
        Tree a = test.addChild("a");
        a.setProperty("foo", (Object)"bar");
        a.addChild("c").setProperty("foo", (Object)"car");
        Tree b = test.addChild("b");
        b.setProperty("foo", (Object)"tar");
        b.addChild("d").setProperty("foo", (Object)"jar");
        this.root.commit();
        Iterator result = this.executeQuery("select [jcr:path] from [nt:base] where isdescendantnode('/test') order by [foo] asc", "JCR-SQL2").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/a/c", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b/d", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/b", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    @Ignore(value="OAK-9261")
    public void testOrderByJcrScore() throws Exception {
        Tree index = this.root.getTree("/oak:index/test-index");
        Assert.assertTrue((boolean)index.exists());
        index.setProperty("rows", (Object)10000);
        index.setProperty("reindex", (Object)true);
        this.root.commit();
        Tree content = this.root.getTree("/").addChild("content");
        Tree a = content.addChild("a");
        a.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        a.setProperty("type", (Object)"doc doc doc");
        this.root.commit();
        String statement = "select [jcr:path], [jcr:score], [rep:excerpt] from [nt:unstructured] as a where contains(*, 'doc') and isdescendantnode(a, '/content') order by [jcr:score] desc";
        Iterator results = this.executeQuery(statement, "JCR-SQL2", true).iterator();
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/a", results.next());
        Assert.assertFalse((boolean)results.hasNext());
    }

    @Test
    public void testOrderByMVProperty() throws Exception {
        Tree index = this.root.getTree("/oak:index/test-index");
        Assert.assertTrue((boolean)index.exists());
        index.setProperty("rows", (Object)10000);
        index.setProperty("reindex", (Object)true);
        this.root.commit();
        Tree content = this.root.getTree("/").addChild("content");
        Tree a = content.addChild("a");
        a.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        a.setProperty("type", Arrays.asList("a", "z"), Type.STRINGS);
        a.setProperty("text", (Object)"a doc");
        Tree aContent = a.addChild("jcr:content");
        aContent.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        aContent.setProperty("type", Collections.singletonList("3"), Type.STRINGS);
        Tree b = content.addChild("b");
        b.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        b.setProperty("type", Arrays.asList("b", "y"), Type.STRINGS);
        b.setProperty("text", (Object)"b doc");
        Tree bContent = b.addChild("jcr:content");
        bContent.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        bContent.setProperty("type", Collections.singletonList("1"), Type.STRINGS);
        this.root.commit();
        Tree c = content.addChild("c");
        c.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        c.setProperty("type", Arrays.asList("c", "x"), Type.STRINGS);
        c.setProperty("text", (Object)"c doc");
        Tree cContent = c.addChild("jcr:content");
        cContent.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        cContent.setProperty("type", Collections.singletonList("2"), Type.STRINGS);
        this.root.commit();
        String statement = "select [jcr:path], [jcr:score] from [nt:unstructured] as a where contains(*, 'doc') and isdescendantnode(a, '/content') order by [type] desc";
        Iterator results = this.executeQuery(statement, "JCR-SQL2", true).iterator();
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/c", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/b", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/a", results.next());
        Assert.assertFalse((boolean)results.hasNext());
        statement = "select [jcr:path], [jcr:score] from [nt:unstructured] as a where contains(*, 'doc') and isdescendantnode(a, '/content') order by [type] asc";
        results = this.executeQuery(statement, "JCR-SQL2", true).iterator();
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/a", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/b", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/c", results.next());
        Assert.assertFalse((boolean)results.hasNext());
    }

    @Test
    public void testCollapsedJcrContentNodeDescandants() throws Exception {
        Tree index = this.root.getTree("/oak:index/test-index");
        Assert.assertTrue((boolean)index.exists());
        index.setProperty("collapseJcrContentNodes", (Object)true);
        index.setProperty("reindex", (Object)true);
        this.root.commit();
        Tree test = this.root.getTree("/").addChild("test");
        Tree content = test.addChild("content");
        Tree content1 = content.addChild("sample1").addChild("jcr:content");
        content1.setProperty("foo", (Object)"bar");
        content1.addChild("text").setProperty("text", (Object)"bar");
        Tree content2 = content.addChild("sample2").addChild("jcr:content");
        content2.setProperty("foo", (Object)"bar");
        content2.addChild("text").setProperty("text", (Object)"bar");
        this.root.commit();
        String xpath = "/jcr:root/test/content//element(*, nt:base)[jcr:contains(., 'bar')]";
        Iterator result = this.executeQuery(xpath, "xpath").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/content/sample1", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/content/sample2", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testJcrContentNodeChild() throws Exception {
        Tree index = this.root.getTree("/oak:index/test-index");
        Assert.assertTrue((boolean)index.exists());
        Tree test = this.root.getTree("/").addChild("test");
        Tree content = test.addChild("content");
        Tree content1 = content.addChild("sample1").addChild("jcr:content");
        content1.setProperty("text", (Object)"bar");
        Tree content2 = content.addChild("sample2").addChild("jcr:content");
        content2.setProperty("foo", (Object)"bar");
        this.root.commit();
        String xpath = "/jcr:root/test/content//element(*, nt:base)[jcr:contains(., 'bar')]";
        Iterator result = this.executeQuery(xpath, "xpath").iterator();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/content/sample1", result.next());
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"/test/content/sample2", result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testNotNullAndNative() throws Exception {
        Tree index = this.root.getTree("/oak:index/test-index");
        Assert.assertTrue((boolean)index.exists());
        index.setProperty("rows", (Object)10000);
        index.setProperty("reindex", (Object)true);
        this.root.commit();
        Tree content = this.root.getTree("/").addChild("content");
        Tree a = content.addChild("a");
        a.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        a.setProperty("foo", (Object)"doc doc doc");
        a.setProperty("loc", (Object)"2");
        Tree b = content.addChild("b");
        b.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        b.setProperty("foo", (Object)"bye bye bye");
        b.setProperty("loc", (Object)"1");
        this.root.commit();
        String query = "select [jcr:path] from [nt:base] where native('solr','select?q=loc:*') AND foo IS NOT NULL";
        Iterator results = this.executeQuery(query, "JCR-SQL2", true).iterator();
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/a", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/content/b", results.next());
        Assert.assertFalse((boolean)results.hasNext());
    }
}

