/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Arrays;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.FilterQueryParser;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.solr.client.solrj.SolrQuery;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@Deprecated(forRemoval=true, since="1.74.0")
public class FilterQueryParserTest {
    @Test
    public void testMatchAllConversionWithNoConstraints() throws Exception {
        Filter filter = (Filter)Mockito.mock(Filter.class);
        OakSolrConfiguration configuration = (OakSolrConfiguration)Mockito.mock(OakSolrConfiguration.class);
        QueryIndex.IndexPlan plan = (QueryIndex.IndexPlan)Mockito.mock(QueryIndex.IndexPlan.class);
        SolrQuery solrQuery = FilterQueryParser.getQuery((Filter)filter, (QueryIndex.IndexPlan)plan, (OakSolrConfiguration)configuration);
        Assert.assertNotNull((Object)solrQuery);
        Assert.assertEquals((Object)"*:*", (Object)solrQuery.getQuery());
    }

    @Test
    public void testAllChildrenQueryParsing() throws Exception {
        String query = "select [jcr:path], [jcr:score], * from [nt:hierarchy] as a where isdescendantnode(a, '/')";
        Filter filter = (Filter)Mockito.mock(Filter.class);
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            public boolean useForPathRestrictions() {
                return true;
            }
        };
        Mockito.when((Object)filter.getQueryStatement()).thenReturn((Object)query);
        Filter.PathRestriction pathRestriction = Filter.PathRestriction.ALL_CHILDREN;
        Mockito.when((Object)filter.getPathRestriction()).thenReturn((Object)pathRestriction);
        Mockito.when((Object)filter.getPath()).thenReturn((Object)"/");
        QueryIndex.IndexPlan plan = (QueryIndex.IndexPlan)Mockito.mock(QueryIndex.IndexPlan.class);
        SolrQuery solrQuery = FilterQueryParser.getQuery((Filter)filter, (QueryIndex.IndexPlan)plan, (OakSolrConfiguration)configuration);
        Assert.assertNotNull((Object)solrQuery);
        String[] filterQueries = solrQuery.getFilterQueries();
        Assert.assertTrue((boolean)Arrays.asList(filterQueries).contains(configuration.getFieldForPathRestriction(pathRestriction) + ":\\/"));
        Assert.assertEquals((Object)"*:*", (Object)solrQuery.get("q"));
    }

    @Test
    public void testCollapseJcrContentNodes() throws Exception {
        String query = "select [jcr:path], [jcr:score], * from [nt:hierarchy] as a where isdescendantnode(a, '/')";
        Filter filter = (Filter)Mockito.mock(Filter.class);
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            public boolean collapseJcrContentNodes() {
                return true;
            }
        };
        Mockito.when((Object)filter.getQueryStatement()).thenReturn((Object)query);
        QueryIndex.IndexPlan plan = (QueryIndex.IndexPlan)Mockito.mock(QueryIndex.IndexPlan.class);
        SolrQuery solrQuery = FilterQueryParser.getQuery((Filter)filter, (QueryIndex.IndexPlan)plan, (OakSolrConfiguration)configuration);
        Assert.assertNotNull((Object)solrQuery);
        String[] filterQueries = solrQuery.getFilterQueries();
        Assert.assertTrue((boolean)Arrays.asList(filterQueries).contains("{!collapse field=" + configuration.getCollapsedPathField() + " min=" + configuration.getPathDepthField() + " hint=top_fc nullPolicy=expand}"));
        Assert.assertEquals((Object)"*:*", (Object)solrQuery.get("q"));
    }
}

