/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.io.File;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Deprecated(forRemoval=true, since="1.74.0")
@Component(immediate=true, service={SolrServerConfigurationProvider.class})
@Designate(ocd=Configuration.class)
public class EmbeddedSolrServerConfigurationProvider
implements SolrServerConfigurationProvider<EmbeddedSolrServerProvider> {
    private String solrHome;
    private String solrCoreName;
    private SolrServerConfiguration<EmbeddedSolrServerProvider> solrServerConfiguration;

    @Activate
    protected void activate(Configuration configuration) throws Exception {
        this.solrHome = configuration.solr_home_path();
        File file = new File(this.solrHome);
        if (!file.exists()) assert (file.createNewFile());
        this.solrCoreName = configuration.solr_core_name();
        this.solrServerConfiguration = new EmbeddedSolrServerConfiguration(this.solrHome, this.solrCoreName);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrHome = null;
        this.solrCoreName = null;
    }

    @NotNull
    public SolrServerConfiguration<EmbeddedSolrServerProvider> getSolrServerConfiguration() {
        return this.solrServerConfiguration;
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.solr.osgi.EmbeddedSolrServerConfigurationProvider", name="Apache Jackrabbit Oak Solr embedded server configuration")
    static @interface Configuration {
        @AttributeDefinition(name="Solr home directory")
        public String solr_home_path() default "solr";

        @AttributeDefinition(name="Solr Core name")
        public String solr_core_name() default "oak";

        public String name() default "embedded";
    }
}

