/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilter;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RandomizedRunner.class)
@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
@Deprecated(forRemoval=true, since="1.74.0")
public class DefaultAnalyzersConfigurationTest
extends BaseTokenStreamTestCase {
    private Analyzer parentPathIndexingAnalyzer;
    private Analyzer parentPathSearchingAnalyzer;
    private Analyzer exactPathAnalyzer;
    private Analyzer directChildrenPathIndexingAnalyzer;
    private Analyzer directChildrenPathSearchingAnalyzer;
    private Analyzer allChildrenPathIndexingAnalyzer;
    private Analyzer allChildrenPathSearchingAnalyzer;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.exactPathAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)source);
            }
        };
        this.parentPathIndexingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)source);
            }
        };
        this.parentPathSearchingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                ReverseStringFilter filter = new ReverseStringFilter((TokenStream)source);
                filter = new PatternReplaceFilter((TokenStream)filter, Pattern.compile("[^\\/]+\\/"), "", false);
                filter = new ReverseStringFilter((TokenStream)filter);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
            }
        };
        this.directChildrenPathIndexingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                ReverseStringFilter filter = new ReverseStringFilter((TokenStream)source);
                filter = new LengthFilter((TokenStream)filter, 2, Integer.MAX_VALUE);
                filter = new PatternReplaceFilter((TokenStream)filter, Pattern.compile("([^\\/]+)(\\/)"), "$2", false);
                filter = new PatternReplaceFilter((TokenStream)filter, Pattern.compile("(\\/)(.+)"), "$2", false);
                filter = new ReverseStringFilter((TokenStream)filter);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
            }
        };
        this.directChildrenPathSearchingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)source);
            }
        };
        this.allChildrenPathIndexingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                PathHierarchyTokenizer source = new PathHierarchyTokenizer();
                PatternCaptureGroupTokenFilter filter = new PatternCaptureGroupTokenFilter((TokenStream)source, false, new Pattern[]{Pattern.compile("((\\/).*)")});
                filter = new RemoveDuplicatesTokenFilter((TokenStream)filter);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
            }
        };
        this.allChildrenPathSearchingAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer source = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)source);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.exactPathAnalyzer.close();
        this.parentPathIndexingAnalyzer.close();
        this.parentPathSearchingAnalyzer.close();
        this.directChildrenPathIndexingAnalyzer.close();
        this.directChildrenPathSearchingAnalyzer.close();
        this.allChildrenPathIndexingAnalyzer.close();
        this.allChildrenPathSearchingAnalyzer.close();
    }

    @Test
    public void testAllChildrenIndexingTokenization() throws Exception {
        try {
            TokenStream ts = this.allChildrenPathIndexingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/jcr:b/c/jcr:d"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a", "/", "/jcr:a/jcr:b", "/jcr:a/jcr:b/c", "/jcr:a/jcr:b/c/jcr:d"});
        }
        finally {
            this.allChildrenPathIndexingAnalyzer.close();
        }
    }

    @Test
    public void testAllChildrenSearchingTokenization() throws Exception {
        try {
            TokenStream ts = this.allChildrenPathSearchingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/jcr:b/jcr:c"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a/jcr:b/jcr:c"});
        }
        finally {
            this.allChildrenPathSearchingAnalyzer.close();
        }
    }

    @Test
    public void testDirectChildrenPathIndexingTokenization() throws Exception {
        try {
            TokenStream ts = this.directChildrenPathIndexingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/b/jcr:c"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a/b"});
            ts = this.directChildrenPathIndexingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/"});
            ts = this.directChildrenPathIndexingAnalyzer.tokenStream("text", (Reader)new StringReader("/"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[0]);
        }
        finally {
            this.directChildrenPathIndexingAnalyzer.close();
        }
    }

    @Test
    public void testDirectChildrenPathSearchingTokenization() throws Exception {
        try {
            TokenStream ts = this.directChildrenPathSearchingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/jcr:b"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a/jcr:b"});
        }
        finally {
            this.directChildrenPathSearchingAnalyzer.close();
        }
    }

    @Test
    public void testExactPathIndexingTokenizationAndSearch() throws Exception {
        try {
            TokenStream ts = this.exactPathAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/jcr:b/c"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a/jcr:b/c"});
        }
        finally {
            this.exactPathAnalyzer.close();
        }
    }

    @Test
    public void testParentPathSearchingTokenization() throws Exception {
        try {
            TokenStream ts = this.parentPathSearchingAnalyzer.tokenStream("text", (Reader)new StringReader("/jcr:a/b/jcr:c"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/jcr:a/b"});
        }
        finally {
            this.parentPathSearchingAnalyzer.close();
        }
    }

    @Test
    public void testParentPathIndexingTokenization() throws Exception {
        try {
            TokenStream ts = this.parentPathIndexingAnalyzer.tokenStream("text", (Reader)new StringReader("/a/b"));
            DefaultAnalyzersConfigurationTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"/a/b"});
        }
        finally {
            this.parentPathIndexingAnalyzer.close();
        }
    }

    @Ignore(value="wrong endOffset")
    @Test
    public void testAllChildrenPathMatching() throws Exception {
        String nodePath = "/jcr:a/jcr:b/c";
        String descendantPath = nodePath + "/d/jcr:e";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathIndexingAnalyzer, (String)descendantPath, (String[])new String[]{"/jcr:a", "/", "/jcr:a/jcr:b", "/jcr:a/jcr:b/c", "/jcr:a/jcr:b/c/d", "/jcr:a/jcr:b/c/d/jcr:e"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)nodePath, (String[])new String[]{nodePath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/jcr:a", (String[])new String[]{"/jcr:a"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/jcr:a/b", (String[])new String[]{"/jcr:a/b"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/a/b/c", (String[])new String[]{"/a/b/c"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/a/b/c/d", (String[])new String[]{"/a/b/c/d"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/a/b/c/d/jcr:e", (String[])new String[]{"/a/b/c/d/jcr:e"});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathSearchingAnalyzer, (String)"/", (String[])new String[]{"/"});
    }

    @Ignore(value="wrong endOffset")
    @Test
    public void testAllChildrenPathMatchingOnRootNode() throws Exception {
        String nodePath = "/";
        String descendantPath = nodePath + "jcr:a/jcr:b";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.allChildrenPathIndexingAnalyzer, (String)descendantPath, (String[])new String[]{"/jcr:a", "/", "/jcr:a/jcr:b"});
    }

    @Test
    public void testDirectChildrenPathMatching() throws Exception {
        String nodePath = "/a/b/c";
        String childPath = nodePath + "/d";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathIndexingAnalyzer, (String)childPath, (String[])new String[]{nodePath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathSearchingAnalyzer, (String)nodePath, (String[])new String[]{nodePath});
        nodePath = "/";
        childPath = nodePath + "/jcr:a";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathIndexingAnalyzer, (String)childPath, (String[])new String[]{nodePath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathSearchingAnalyzer, (String)nodePath, (String[])new String[]{nodePath});
        String childPath1 = "/test/jcr:resource";
        String childPath2 = "/test/resource";
        nodePath = "/test";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathIndexingAnalyzer, (String)childPath1, (String[])new String[]{nodePath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathIndexingAnalyzer, (String)childPath2, (String[])new String[]{nodePath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.directChildrenPathSearchingAnalyzer, (String)nodePath, (String[])new String[]{nodePath});
    }

    @Test
    public void testParentPathMatching() throws Exception {
        String parentPath = "/a/b";
        String nodePath = parentPath + "/jcr:c";
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.parentPathIndexingAnalyzer, (String)parentPath, (String[])new String[]{parentPath});
        DefaultAnalyzersConfigurationTest.assertAnalyzesTo((Analyzer)this.parentPathSearchingAnalyzer, (String)nodePath, (String[])new String[]{parentPath});
    }
}

