/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.AbstractQueryTest;

@Deprecated(forRemoval=true, since="1.74.0")
public class SpellcheckTest
extends AbstractQueryTest {
    public void testSpellcheckSql() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "hello hello hello alt");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "hold");
        session.save();
        String sql = "SELECT [rep:spellcheck()] FROM nt:base WHERE [jcr:path] = '/' AND SPELLCHECK('helo')";
        Query q = qm.createQuery(sql, "sql");
        List<String> result = SpellcheckTest.getResult(q.execute(), "rep:spellcheck()");
        SpellcheckTest.assertNotNull(result);
        SpellcheckTest.assertEquals((int)2, (int)result.size());
        SpellcheckTest.assertEquals((String)"[hello, hold]", (String)result.toString());
    }

    public void testSpellcheckXPath() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "hello hello hello alt");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "hold");
        session.save();
        String xpath = "/jcr:root[rep:spellcheck('helo')]/(rep:spellcheck())";
        Query q = qm.createQuery(xpath, "xpath");
        List<String> result = SpellcheckTest.getResult(q.execute(), "rep:spellcheck()");
        SpellcheckTest.assertNotNull(result);
        SpellcheckTest.assertEquals((int)2, (int)result.size());
        SpellcheckTest.assertEquals((String)"[hello, hold]", (String)result.toString());
    }

    public void testSpellcheckMultipleWords() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "it is always a good idea to go visiting ontario");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "ontario is a nice place to live in");
        Node n3 = this.testRootNode.addNode("node3");
        n2.setProperty("jcr:title", "I flied to ontario for voting for the major polls");
        Node n4 = this.testRootNode.addNode("node4");
        n2.setProperty("jcr:title", "I will go voting in ontario, I always voted since I've been allowed to");
        session.save();
        String xpath = "/jcr:root[rep:spellcheck('votin in ontari')]/(rep:spellcheck())";
        Query q = qm.createQuery(xpath, "xpath");
        List<String> result = SpellcheckTest.getResult(q.execute(), "rep:spellcheck()");
        SpellcheckTest.assertNotNull(result);
        SpellcheckTest.assertEquals((int)1, (int)result.size());
        SpellcheckTest.assertEquals((String)"voting in ontario", (String)result.get(0));
    }

    static List<String> getResult(QueryResult result, String propertyName) throws RepositoryException {
        ArrayList<String> results = new ArrayList<String>();
        RowIterator it = result.getRows();
        while (it.hasNext()) {
            Row row = it.nextRow();
            results.add(row.getValue(propertyName).getString());
        }
        return results;
    }
}

