/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import org.apache.jackrabbit.oak.plugins.index.solr.query.LMSEstimator;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.solr.common.SolrDocumentList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LMSEstimatorTest {
    @Test
    public void testUpdate() throws Exception {
        LMSEstimator lmsEstimator = new LMSEstimator();
        Filter filter = (Filter)Mockito.mock(Filter.class);
        SolrDocumentList docs = (SolrDocumentList)Mockito.mock(SolrDocumentList.class);
        lmsEstimator.update(filter, docs);
    }

    @Test
    public void testMultipleUpdates() throws Exception {
        LMSEstimator lmsEstimator = new LMSEstimator();
        Filter filter = (Filter)Mockito.mock(Filter.class);
        FullTextTerm fte = new FullTextTerm("foo", "bar", false, false, "");
        Mockito.when((Object)filter.getFullTextConstraint()).thenReturn((Object)fte);
        SolrDocumentList docs = new SolrDocumentList();
        lmsEstimator.update(filter, docs);
        long actualCount = 10L;
        docs.setNumFound(actualCount);
        long estimate = lmsEstimator.estimate(filter);
        long diff = actualCount - estimate;
        lmsEstimator.update(filter, docs);
        long estimate2 = lmsEstimator.estimate(filter);
        long diff2 = actualCount - estimate2;
        Assert.assertTrue((diff2 < diff ? 1 : 0) != 0);
        lmsEstimator.update(filter, docs);
        long estimate3 = lmsEstimator.estimate(filter);
        Assert.assertEquals((long)estimate3, (long)estimate2);
    }

    @Test
    public void testEstimate() throws Exception {
        LMSEstimator lmsEstimator = new LMSEstimator();
        Filter filter = (Filter)Mockito.mock(Filter.class);
        long estimate = lmsEstimator.estimate(filter);
        Assert.assertEquals((long)0L, (long)estimate);
    }
}

