/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.AbstractQueryTest;

public class SuggestTest
extends AbstractQueryTest {
    public void testSuggestSql() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "in 2015 my fox is red, like mike's fox and john's fox");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "in 2015 a red fox is still a fox");
        session.save();
        String sql = "SELECT [rep:suggest()] FROM nt:base WHERE [jcr:path] = '/' AND SUGGEST('in 201')";
        Query q = qm.createQuery(sql, "sql");
        List<String> result = SuggestTest.getResult(q.execute(), "rep:suggest()");
        SuggestTest.assertNotNull(result);
        SuggestTest.assertEquals((int)2, (int)result.size());
        SuggestTest.assertTrue((boolean)result.contains("in 2015 a red fox is still a fox"));
        SuggestTest.assertTrue((boolean)result.contains("in 2015 my fox is red, like mike's fox and john's fox"));
    }

    public void testSuggestXPath() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "in 2015 my fox is red, like mike's fox and john's fox");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "in 2015 a red fox is still a fox");
        session.save();
        String xpath = "/jcr:root[rep:suggest('in 201')]/(rep:suggest())";
        Query q = qm.createQuery(xpath, "xpath");
        List<String> result = SuggestTest.getResult(q.execute(), "rep:suggest()");
        SuggestTest.assertNotNull(result);
        SuggestTest.assertEquals((int)2, (int)result.size());
        SuggestTest.assertTrue((boolean)result.contains("in 2015 a red fox is still a fox"));
        SuggestTest.assertTrue((boolean)result.contains("in 2015 my fox is red, like mike's fox and john's fox"));
    }

    public void testNoSuggestions() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "in 2015 my fox is red, like mike's fox and john's fox");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "in 2015 a red fox is still a fox");
        session.save();
        String sql = "SELECT [rep:suggest()] FROM nt:base WHERE [jcr:path] = '/' AND SUGGEST('blablabla')";
        Query q = qm.createQuery(sql, "sql");
        List<String> result = SuggestTest.getResult(q.execute(), "rep:suggest()");
        SuggestTest.assertNotNull(result);
        SuggestTest.assertEquals((String)"There shouldn't be any suggestions", (int)0, (int)result.size());
    }

    static List<String> getResult(QueryResult result, String propertyName) throws RepositoryException {
        ArrayList results = Lists.newArrayList();
        RowIterator it = result.getRows();
        while (it.hasNext()) {
            Row row = it.nextRow();
            results.add(row.getValue(propertyName).getString());
        }
        return results;
    }
}

