/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.query.AbstractQueryTest;
import org.apache.jackrabbit.oak.query.facet.FacetResult;

public class FacetTest
extends AbstractQueryTest {
    public void testFacetRetrieval() throws Exception {
        Session session = this.superuser;
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("text", "oh hallo");
        session.save();
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path], [rep:facet(text)] from [nt:base] where contains([text], 'hello OR hallo') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        FacetResult facetResult = new FacetResult(result);
        FacetTest.assertNotNull((Object)facetResult);
        FacetTest.assertNotNull((Object)facetResult.getDimensions());
        FacetTest.assertEquals((int)1, (int)facetResult.getDimensions().size());
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains("text"));
        List facets = facetResult.getFacets("text");
        FacetTest.assertNotNull((Object)facets);
        FacetTest.assertEquals((String)"hallo", (String)((FacetResult.Facet)facets.get(0)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"hello", (String)((FacetResult.Facet)facets.get(1)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(1)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"oh hallo", (String)((FacetResult.Facet)facets.get(2)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(2)).getCount(), (float)0.0f);
        NodeIterator nodes = result.getNodes();
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertFalse((boolean)nodes.hasNext());
    }

    public void testFacetRetrievalMV() throws Exception {
        Session session = this.superuser;
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("jcr:title", "apache jackrabbit oak");
        n1.setProperty("tags", new String[]{"software", "repository", "apache"});
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("jcr:title", "oak furniture");
        n2.setProperty("tags", "furniture");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("jcr:title", "oak cosmetics");
        n3.setProperty("tags", "cosmetics");
        Node n4 = this.testRootNode.addNode("node4");
        n4.setProperty("jcr:title", "oak and aem");
        n4.setProperty("tags", new String[]{"software", "repository", "aem"});
        session.save();
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path], [rep:facet(tags)] from [nt:base] where contains([jcr:title], 'oak') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        FacetResult facetResult = new FacetResult(result);
        FacetTest.assertNotNull((Object)facetResult);
        FacetTest.assertNotNull((Object)facetResult.getDimensions());
        FacetTest.assertEquals((int)1, (int)facetResult.getDimensions().size());
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains("tags"));
        List facets = facetResult.getFacets("tags");
        FacetTest.assertNotNull((Object)facets);
        FacetTest.assertEquals((String)"repository", (String)((FacetResult.Facet)facets.get(0)).getLabel());
        FacetTest.assertEquals((float)2.0f, (float)((FacetResult.Facet)facets.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"software", (String)((FacetResult.Facet)facets.get(1)).getLabel());
        FacetTest.assertEquals((float)2.0f, (float)((FacetResult.Facet)facets.get(1)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"aem", (String)((FacetResult.Facet)facets.get(2)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(2)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"apache", (String)((FacetResult.Facet)facets.get(3)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(3)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"cosmetics", (String)((FacetResult.Facet)facets.get(4)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(4)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"furniture", (String)((FacetResult.Facet)facets.get(5)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(5)).getCount(), (float)0.0f);
        NodeIterator nodes = result.getNodes();
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertFalse((boolean)nodes.hasNext());
    }

    public void testFacetRetrievalWithAnonymousUser() throws Exception {
        Session session = this.superuser;
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("text", "oh hallo");
        session.save();
        session = this.getHelper().getReadOnlySession();
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path], [rep:facet(text)] from [nt:base] where contains([text], 'hello OR hallo') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        FacetResult facetResult = new FacetResult(result);
        FacetTest.assertNotNull((Object)facetResult);
        FacetTest.assertNotNull((Object)facetResult.getDimensions());
        FacetTest.assertEquals((int)1, (int)facetResult.getDimensions().size());
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains("text"));
        List facets = facetResult.getFacets("text");
        FacetTest.assertNotNull((Object)facets);
        FacetTest.assertEquals((String)"hallo", (String)((FacetResult.Facet)facets.get(0)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"hello", (String)((FacetResult.Facet)facets.get(1)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(1)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"oh hallo", (String)((FacetResult.Facet)facets.get(2)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(2)).getCount(), (float)0.0f);
        NodeIterator nodes = result.getNodes();
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertFalse((boolean)nodes.hasNext());
    }

    public void testFacetRetrieval2() throws Exception {
        Session session = this.superuser;
        Node n1 = this.testRootNode.addNode("node1");
        String pn = "jcr:title";
        n1.setProperty(pn, "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty(pn, "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty(pn, "oh hallo");
        session.save();
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path], [rep:facet(" + pn + ")] from [nt:base] " + "where contains([" + pn + "], 'hallo') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        FacetResult facetResult = new FacetResult(result);
        FacetTest.assertNotNull((Object)facetResult);
        FacetTest.assertNotNull((Object)facetResult.getDimensions());
        FacetTest.assertEquals((int)1, (int)facetResult.getDimensions().size());
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains(pn));
        List facets = facetResult.getFacets(pn);
        FacetTest.assertNotNull((Object)facets);
        FacetTest.assertEquals((String)"hallo", (String)((FacetResult.Facet)facets.get(0)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"oh hallo", (String)((FacetResult.Facet)facets.get(1)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(1)).getCount(), (float)0.0f);
        NodeIterator nodes = result.getNodes();
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertFalse((boolean)nodes.hasNext());
    }

    public void testMultipleFacetsRetrieval() throws Exception {
        Session session = this.superuser;
        Node n1 = this.testRootNode.addNode("node1");
        String pn = "jcr:title";
        String pn2 = "jcr:description";
        n1.setProperty(pn, "hello");
        n1.setProperty(pn2, "a");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty(pn, "hallo");
        n2.setProperty(pn2, "b");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty(pn, "oh hallo");
        n3.setProperty(pn2, "a");
        session.save();
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path], [rep:facet(" + pn + ")], [rep:facet(" + pn2 + ")] from [nt:base] " + "where contains([" + pn + "], 'hallo') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        FacetResult facetResult = new FacetResult(result);
        FacetTest.assertNotNull((Object)facetResult);
        FacetTest.assertNotNull((Object)facetResult.getDimensions());
        FacetTest.assertEquals((int)2, (int)facetResult.getDimensions().size());
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains(pn));
        FacetTest.assertTrue((boolean)facetResult.getDimensions().contains(pn2));
        List facets = facetResult.getFacets(pn);
        FacetTest.assertNotNull((Object)facets);
        FacetTest.assertEquals((String)"hallo", (String)((FacetResult.Facet)facets.get(0)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"oh hallo", (String)((FacetResult.Facet)facets.get(1)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets.get(1)).getCount(), (float)0.0f);
        List facets1 = facetResult.getFacets(pn2);
        FacetTest.assertNotNull((Object)facets1);
        FacetTest.assertEquals((String)"a", (String)((FacetResult.Facet)facets1.get(0)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets1.get(0)).getCount(), (float)0.0f);
        FacetTest.assertEquals((String)"b", (String)((FacetResult.Facet)facets1.get(1)).getLabel());
        FacetTest.assertEquals((float)1.0f, (float)((FacetResult.Facet)facets1.get(1)).getCount(), (float)0.0f);
        NodeIterator nodes = result.getNodes();
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertTrue((boolean)nodes.hasNext());
        FacetTest.assertNotNull((Object)nodes.nextNode());
        FacetTest.assertFalse((boolean)nodes.hasNext());
    }
}

