/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.RemoteSolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.NamedList;
import org.junit.Assert;
import org.junit.Test;

public class RemoteSolrServerProviderIT {
    private final String[] zkHosts = new String[]{"localhost:9983"};

    private boolean canCreateCollections(String host) throws Exception {
        UpdateRequest req = new UpdateRequest("/admin/collections");
        req.setParam("action", "CREATE");
        String solrCollection = "solr_" + System.nanoTime();
        req.setParam("name", solrCollection);
        req.setParam("numShards", "2");
        req.setParam("replicationFactor", "2");
        req.setParam("collection.configName", "myconf");
        CloudSolrClient cloudSolrServer = new CloudSolrClient.Builder().withZkHost(host).build();
        cloudSolrServer.setZkConnectTimeout(1000);
        NamedList request = cloudSolrServer.request((SolrRequest)req);
        return request != null && request.get("success") != null;
    }

    @Test
    public void testCloudRemoteServerCreation() throws Exception {
        for (String host : this.zkHosts) {
            boolean cloudServerAvailable = false;
            try {
                cloudServerAvailable = this.canCreateCollections(host);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!cloudServerAvailable) continue;
            String collection = "sample_" + System.nanoTime();
            RemoteSolrServerProvider remoteSolrServerProvider = new RemoteSolrServerProvider(new RemoteSolrServerConfiguration(host, collection, 2, 2, null, 10, 10, null));
            SolrClient solrServer = remoteSolrServerProvider.getSolrServer();
            Assert.assertNotNull((Object)solrServer);
            solrServer.close();
            break;
        }
    }
}

