/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Iterator;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.DefaultSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.query.AbstractQueryTest;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class SubtreeSolrIndexIT
extends AbstractQueryTest {
    public static final String SUBTREE = "subtree";
    @Rule
    public TestName name = new TestName();

    protected void createTestIndexNode() throws Exception {
        Tree rootTree = this.root.getTree("/");
        Tree subtree = rootTree.addChild(SUBTREE);
        Tree solrIndexNode = SubtreeSolrIndexIT.createTestIndexNode((Tree)subtree, (String)"solr");
        solrIndexNode.setProperty("pathRestrictions", (Object)false);
        solrIndexNode.setProperty("propertyRestrictions", (Object)true);
        solrIndexNode.setProperty("primaryTypes", (Object)false);
        solrIndexNode.setProperty("commitPolicy", (Object)"hard");
        Tree server = solrIndexNode.addChild("server");
        server.setProperty("solrServerType", (Object)"embedded");
        server.setProperty("solrHomePath", (Object)("target/" + this.name.getMethodName()));
        this.root.commit();
    }

    protected ContentRepository createRepository() {
        try {
            DefaultSolrServerProvider solrServerProvider = new DefaultSolrServerProvider();
            DefaultSolrConfigurationProvider oakSolrConfigurationProvider = new DefaultSolrConfigurationProvider();
            return new Oak().with((RepositoryInitializer)new InitialContent()).with((SecurityProvider)new OpenSecurityProvider()).with((QueryIndexProvider)new SolrQueryIndexProvider((SolrServerProvider)solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider)).with((IndexEditorProvider)new SolrIndexEditorProvider((SolrServerProvider)solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider)).createContentRepository();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test() throws Exception {
        Tree content = this.root.getTree("/").getChild(SUBTREE);
        Tree a = content.addChild("a");
        a.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        a.setProperty("foo", (Object)"doc bye");
        a.setProperty("loc", (Object)"2");
        Tree b = content.addChild("b");
        b.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        b.setProperty("foo", (Object)"bye doc bye");
        b.setProperty("loc", (Object)"1");
        this.root.commit();
        String query = "select [jcr:path] from [nt:base] where contains(*,'doc') AND isdescendantnode('/subtree')";
        Iterator results = this.executeQuery(query, "JCR-SQL2", true).iterator();
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/subtree/a", results.next());
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"/subtree/b", results.next());
        Assert.assertFalse((boolean)results.hasNext());
    }
}

