/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.OakSolrNodeStateConfiguration;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OakSolrNodeStateConfigurationTest {
    private NodeStore store;

    @Before
    public void setUp() throws Exception {
        this.store = SegmentNodeStoreBuilders.builder((MemoryStore)new MemoryStore()).build();
        NodeBuilder builder = this.store.getRoot().builder();
        builder.setProperty("a", (Object)1).setProperty("b", (Object)2).setProperty("c", (Object)3);
        builder.setChildNode("x");
        builder.setChildNode("y");
        builder.setChildNode("z");
        builder.setChildNode("oak:index").setChildNode("solrIdx").setProperty("type", (Object)"solr").setProperty("rows", (Object)"100");
        this.store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    @Test
    public void testExistingPath() throws Exception {
        NodeState idxDef = this.store.getRoot().getChildNode("oak:index").getChildNode("solrIdx");
        OakSolrNodeStateConfiguration nodeStateConfiguration = new OakSolrNodeStateConfiguration(idxDef);
        Assert.assertNotNull((Object)nodeStateConfiguration.getCatchAllField());
    }

    @Test
    public void testNonExistingPath() throws Exception {
        NodeState idxDef = this.store.getRoot().getChildNode("oak:index").getChildNode("a");
        try {
            new OakSolrNodeStateConfiguration(idxDef);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWrongNodeState() throws Exception {
        NodeState idxDef = this.store.getRoot().getChildNode("x");
        try {
            new OakSolrNodeStateConfiguration(idxDef);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

