/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.solr.client.solrj.SolrServer;

public class SolrServerRegistry {
    private static final Map<String, SolrServer> searchingServerRegistry = new HashMap<String, SolrServer>();
    private static final Map<String, SolrServer> indexingServerRegistry = new HashMap<String, SolrServer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(@Nonnull SolrServerConfiguration configuration, @Nonnull SolrServer solrServer, @Nonnull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrServer> map = indexingServerRegistry;
                synchronized (map) {
                    indexingServerRegistry.put(configuration.toString(), solrServer);
                    break;
                }
            }
            case SEARCHING: {
                Map<String, SolrServer> map = searchingServerRegistry;
                synchronized (map) {
                    searchingServerRegistry.put(configuration.toString(), solrServer);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static SolrServer get(@Nonnull SolrServerConfiguration configuration, @Nonnull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrServer> map = indexingServerRegistry;
                synchronized (map) {
                    return indexingServerRegistry.get(configuration.toString());
                }
            }
            case SEARCHING: {
                Map<String, SolrServer> map = searchingServerRegistry;
                synchronized (map) {
                    return searchingServerRegistry.get(configuration.toString());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(SolrServerConfiguration configuration, @Nonnull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrServer> map = indexingServerRegistry;
                synchronized (map) {
                    SolrServer removed = indexingServerRegistry.remove(configuration.toString());
                    try {
                        removed.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
            }
            case SEARCHING: {
                Map<String, SolrServer> map = searchingServerRegistry;
                synchronized (map) {
                    SolrServer removed = searchingServerRegistry.remove(configuration.toString());
                    try {
                        removed.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
            }
        }
    }

    public static enum Strategy {
        INDEXING,
        SEARCHING;

    }
}

