/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.IOException;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class DefaultSolrServerProvider
implements SolrServerProvider {
    private SolrServer solrServer;
    private SolrServer indexingSolrServer;

    @Override
    @CheckForNull
    public SolrServer getSolrServer() throws Exception {
        if (this.solrServer == null) {
            this.solrServer = new HttpSolrServer(this.getUrl());
        }
        return this.solrServer;
    }

    @Override
    @CheckForNull
    public SolrServer getIndexingSolrServer() throws Exception {
        if (this.indexingSolrServer == null) {
            this.indexingSolrServer = new ConcurrentUpdateSolrServer(this.getUrl(), 1000, 4);
        }
        return this.indexingSolrServer;
    }

    @Override
    @CheckForNull
    public SolrServer getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private String getUrl() {
        return "http://127.0.0.1:8983/solr/oak";
    }

    @Override
    public void close() throws IOException {
        try {
            SolrServer solrServer = this.getSolrServer();
            if (solrServer != null) {
                solrServer.shutdown();
            }
        }
        catch (Exception solrServer) {
            // empty catch block
        }
        try {
            SolrServer indexingSolrServer = this.getIndexingSolrServer();
            if (indexingSolrServer != null) {
                indexingSolrServer.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getSearchingSolrServer().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

