/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.TestUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditor;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SolrIndexEditorTest {
    @Test
    public void testIndexedProperties() throws Exception {
        SolrServer solrServer = TestUtils.createSolrServer();
        OakSolrConfiguration configuration = TestUtils.getTestConfiguration();
        IndexUpdateCallback callback = (IndexUpdateCallback)Mockito.mock(IndexUpdateCallback.class);
        SolrIndexEditor solrIndexEditor = new SolrIndexEditor(solrServer, configuration, callback);
        NodeState before = (NodeState)Mockito.mock(NodeState.class);
        NodeState after = (NodeState)Mockito.mock(NodeState.class);
        Iterable<PropertyState> properties = new Iterable<PropertyState>(){

            @Override
            public Iterator<PropertyState> iterator() {
                return Arrays.asList(PropertyStates.createProperty((String)"foo1", (Object)"bar")).iterator();
            }
        };
        Mockito.when((Object)after.getProperties()).thenReturn((Object)properties);
        solrIndexEditor.leave(before, after);
        QueryResponse queryResponse = solrServer.query((SolrParams)new SolrQuery("foo1:*"));
        Assert.assertEquals((long)1L, (long)queryResponse.getResults().getNumFound());
    }

    @Test
    public void testIgnoredPropertiesNotIndexed() throws Exception {
        NodeBuilder builder = (NodeBuilder)Mockito.mock(NodeBuilder.class);
        SolrServer solrServer = TestUtils.createSolrServer();
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            @Nonnull
            public Collection<String> getIgnoredProperties() {
                return Arrays.asList("foo2");
            }

            @Nonnull
            public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                return OakSolrConfiguration.CommitPolicy.HARD;
            }
        };
        IndexUpdateCallback callback = (IndexUpdateCallback)Mockito.mock(IndexUpdateCallback.class);
        SolrIndexEditor solrIndexEditor = new SolrIndexEditor(solrServer, (OakSolrConfiguration)configuration, callback);
        NodeState before = (NodeState)Mockito.mock(NodeState.class);
        NodeState after = (NodeState)Mockito.mock(NodeState.class);
        Iterable<PropertyState> properties = new Iterable<PropertyState>(){

            @Override
            public Iterator<PropertyState> iterator() {
                return Arrays.asList(PropertyStates.createProperty((String)"foo2", (Object)"bar")).iterator();
            }
        };
        Mockito.when((Object)after.getProperties()).thenReturn((Object)properties);
        solrIndexEditor.leave(before, after);
        QueryResponse queryResponse = solrServer.query((SolrParams)new SolrQuery("foo2:*"));
        Assert.assertEquals((long)0L, (long)queryResponse.getResults().getNumFound());
    }
}

